/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.Comparator;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeEqual;
import org.fest.assertions.error.ShouldBeGreater;
import org.fest.assertions.error.ShouldBeGreaterOrEqual;
import org.fest.assertions.error.ShouldBeLess;
import org.fest.assertions.error.ShouldBeLessOrEqual;
import org.fest.assertions.error.ShouldNotBeEqual;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Objects;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.StandardComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparables {
    private static final Comparables INSTANCE = new Comparables();
    @VisibleForTesting
    Failures failures = Failures.instance();
    ComparisonStrategy comparisonStrategy;

    public static Comparables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Comparables() {
        this((ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public Comparables(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    @VisibleForTesting
    void setFailures(Failures failures) {
        this.failures = failures;
    }

    public <T> void assertEqual(AssertionInfo info, T actual, T expected) {
        Comparables.assertNotNull(info, actual);
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy));
    }

    protected <T> boolean areEqual(T actual, T expected) {
        return this.comparisonStrategy.areEqual(actual, expected);
    }

    public <T> void assertNotEqual(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertEqualByComparison(AssertionInfo info, T actual, T expected) {
        Comparables.assertNotNull(info, actual);
        if (actual.compareTo(expected) == 0) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected));
    }

    public <T extends Comparable<? super T>> void assertNotEqualByComparison(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (actual.compareTo(other) != 0) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other));
    }

    public <T extends Comparable<? super T>> void assertLessThan(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (this.isLessThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLess.shouldBeLess(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertLessThanOrEqualTo(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (!this.isGreaterThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLessOrEqual.shouldBeLessOrEqual(actual, other, this.comparisonStrategy));
    }

    public <T extends Comparable<? super T>> void assertGreaterThan(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (this.isGreaterThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeGreater.shouldBeGreater(actual, other, this.comparisonStrategy));
    }

    private boolean isGreaterThan(Object actual, Object other) {
        return this.comparisonStrategy.isGreaterThan(actual, other);
    }

    public <T extends Comparable<? super T>> void assertGreaterThanOrEqualTo(AssertionInfo info, T actual, T other) {
        Comparables.assertNotNull(info, actual);
        if (!this.isLessThan(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeGreaterOrEqual.shouldBeGreaterOrEqual(actual, other, this.comparisonStrategy));
    }

    private boolean isLessThan(Object actual, Object other) {
        return this.comparisonStrategy.isLessThan(actual, other);
    }

    protected static <T> void assertNotNull(AssertionInfo info, T actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

