/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.NoSuchElementException;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class SingletonMultiDataSetIterator
implements MultiDataSetIterator {
    private final MultiDataSet multiDataSet;
    private boolean hasNext = true;
    private boolean preprocessed = false;
    private MultiDataSetPreProcessor preProcessor;

    public SingletonMultiDataSetIterator(MultiDataSet multiDataSet) {
        this.multiDataSet = multiDataSet;
    }

    public MultiDataSet next(int num) {
        return this.next();
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return false;
    }

    public void reset() {
        this.hasNext = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public MultiDataSet next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No elements remaining");
        }
        this.hasNext = false;
        if (this.preProcessor != null && !this.preprocessed) {
            this.preProcessor.preProcess(this.multiDataSet);
            this.preprocessed = true;
        }
        return this.multiDataSet;
    }

    public void remove() {
    }
}

