/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.cym2.awss3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public class WagonAuthCredentialsProvider
implements AWSCredentialsProvider {
    @Nullable
    private final AuthenticationInfo authenticationInfo;

    WagonAuthCredentialsProvider(AuthenticationInfo authInfo) {
        this.authenticationInfo = authInfo;
    }

    public AWSCredentials getCredentials() {
        if (this.authenticationInfo == null) {
            throw new IllegalStateException("No authentication information is specified.");
        }
        if (StringUtils.isEmpty((String)this.authenticationInfo.getUserName())) {
            throw new IllegalStateException("Tag <username> isn't specified with AWS access key ID in pom.xml or settings.xml.");
        }
        if (StringUtils.isEmpty((String)this.authenticationInfo.getPassword())) {
            throw new IllegalStateException("Tag <password> isn't specified with AWS secret key in pom.xml or settings.xml.");
        }
        return new BasicAWSCredentials(this.authenticationInfo.getUserName(), this.authenticationInfo.getPassword());
    }

    public void refresh() {
    }
}

