/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.model.ExtensibleType;
import org.cyclonedx.model.Extension;
import org.cyclonedx.model.vulnerability.Rating;
import org.cyclonedx.model.vulnerability.Vulnerability10;

public class ExtensionSerializer
extends StdSerializer<Extension> {
    public ExtensionSerializer() {
        this(null);
    }

    public ExtensionSerializer(Class<Extension> t) {
        super(t);
    }

    public void serialize(Extension value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.getExtensionType().equals((Object)Extension.ExtensionType.VULNERABILITIES) && gen instanceof ToXmlGenerator) {
            try {
                this.serializeVulnerabilities((ToXmlGenerator)gen, value);
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
    }

    private void serializeVulnerabilities(ToXmlGenerator gen, Extension vulns) throws XMLStreamException {
        XMLStreamWriter staxWriter = gen.getStaxWriter();
        staxWriter.writeStartElement("v", "vulnerabilities", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
        for (ExtensibleType ext : vulns.getExtensions()) {
            Vulnerability10 vuln = (Vulnerability10)ext;
            staxWriter.writeStartElement("v", "vulnerability", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
            staxWriter.writeAttribute("ref", vuln.getRef());
            this.generateTextNode(staxWriter, "id", vuln.getId(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
            this.processRatings(staxWriter, vuln);
            this.processCwes(staxWriter, vuln);
            this.generateTextNode(staxWriter, "description", vuln.getDescription(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
            this.processRecommendations(staxWriter, vuln);
            this.processAdvisories(staxWriter, vuln);
            this.processSource(staxWriter, vuln);
            staxWriter.writeEndElement();
        }
        staxWriter.writeEndElement();
    }

    private void processAdvisories(XMLStreamWriter staxWriter, Vulnerability10 vuln) throws XMLStreamException {
        if (CollectionUtils.isNotEmpty(vuln.getAdvisories())) {
            staxWriter.writeStartElement("v", "advisories", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
            for (Vulnerability10.Advisory a : vuln.getAdvisories()) {
                this.generateTextNode(staxWriter, "advisory", a.getText(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
            }
            staxWriter.writeEndElement();
        }
    }

    private void processRecommendations(XMLStreamWriter staxWriter, Vulnerability10 vuln) throws XMLStreamException {
        if (CollectionUtils.isNotEmpty(vuln.getRecommendations())) {
            staxWriter.writeStartElement("v", "recommendations", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
            for (Vulnerability10.Recommendation r : vuln.getRecommendations()) {
                this.generateTextNode(staxWriter, "recommendation", r.getText(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
            }
            staxWriter.writeEndElement();
        }
    }

    private void processCwes(XMLStreamWriter staxWriter, Vulnerability10 vuln) throws XMLStreamException {
        if (CollectionUtils.isNotEmpty(vuln.getCwes())) {
            staxWriter.writeStartElement("v", "cwes", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
            for (Vulnerability10.Cwe c : vuln.getCwes()) {
                this.generateTextNodeFromNumber(staxWriter, "cwe", c.getText(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
            }
            staxWriter.writeEndElement();
        }
    }

    private void processSource(XMLStreamWriter staxWriter, Vulnerability10 vulnerability) throws XMLStreamException {
        if (vulnerability.getSource() != null && vulnerability.getSource().getName() != null) {
            staxWriter.writeStartElement("v", "source", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
            staxWriter.writeAttribute("name", vulnerability.getSource().getName());
            if (vulnerability.getSource().getUrl() != null) {
                this.generateTextNode(staxWriter, "url", vulnerability.getSource().getUrl().toString(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
            }
            staxWriter.writeEndElement();
        }
    }

    private void processRatings(XMLStreamWriter staxWriter, Vulnerability10 vuln) throws XMLStreamException {
        if (CollectionUtils.isNotEmpty(vuln.getRatings())) {
            staxWriter.writeStartElement("v", "ratings", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
            for (Rating r : vuln.getRatings()) {
                staxWriter.writeStartElement("v", "rating", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
                if (r.getScore() != null) {
                    staxWriter.writeStartElement("v", "score", "http://cyclonedx.org/schema/ext/vulnerability/1.0");
                    this.generateTextNodeFromNumber(staxWriter, "base", r.getScore().getBase(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
                    this.generateTextNodeFromNumber(staxWriter, "impact", r.getScore().getImpact(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
                    this.generateTextNodeFromNumber(staxWriter, "exploitability", r.getScore().getExploitability(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
                    staxWriter.writeEndElement();
                }
                if (r.getSeverity() != null) {
                    this.generateTextNode(staxWriter, "severity", r.getSeverity().getSeverityName(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
                }
                if (r.getMethod() != null) {
                    this.generateTextNode(staxWriter, "method", r.getMethod().getScoreSourceName(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
                }
                this.generateTextNode(staxWriter, "vector", r.getVector(), "http://cyclonedx.org/schema/ext/vulnerability/1.0", "v");
                staxWriter.writeEndElement();
            }
            staxWriter.writeEndElement();
        }
    }

    private void generateTextNodeFromNumber(XMLStreamWriter writer, String fieldName, Number value, String namespaceUri, String prefix) throws XMLStreamException {
        if (value != null) {
            this.generateTextNode(writer, fieldName, value.toString(), namespaceUri, prefix);
        }
    }

    private void generateTextNode(XMLStreamWriter writer, String fieldName, String value, String namespaceUri, String prefix) throws XMLStreamException {
        if (value != null) {
            writer.writeStartElement(prefix, fieldName, namespaceUri);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
    }
}

