/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.license.Expression;
import org.cyclonedx.util.deserializer.DeserializerUtils;
import org.cyclonedx.util.deserializer.ExpressionDeserializer;

public class LicenseDeserializer
extends JsonDeserializer<LicenseChoice> {
    final ExpressionDeserializer expressionDeserializer = new ExpressionDeserializer();

    public LicenseChoice deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper codec = (ObjectMapper)p.getCodec();
        boolean isXml = codec instanceof XmlMapper;
        JsonNode rootNode = (JsonNode)p.getCodec().readTree(p);
        if (!rootNode.isEmpty()) {
            ArrayNode nodes = DeserializerUtils.getArrayNode(rootNode, null);
            LicenseChoice licenseChoice = new LicenseChoice();
            for (JsonNode node : nodes) {
                if (isXml) {
                    if (node.has("license")) {
                        this.processLicenseNode(p, node.get("license"), licenseChoice);
                        continue;
                    }
                    this.processExpression(p, node, licenseChoice, ctxt);
                    continue;
                }
                if (node.has("expression")) {
                    this.processExpression(p, node, licenseChoice, ctxt);
                    continue;
                }
                this.processLicenseNode(p, node, licenseChoice);
            }
            return licenseChoice;
        }
        return null;
    }

    private void processLicenseNode(JsonParser p, JsonNode licenseNode, LicenseChoice licenseChoice) throws IOException {
        ArrayNode licenseNodes = DeserializerUtils.getArrayNode(licenseNode, null);
        for (JsonNode license : licenseNodes) {
            License licenseObj = (License)p.getCodec().treeToValue((TreeNode)license, License.class);
            licenseChoice.addLicense(licenseObj);
        }
    }

    private void processExpression(JsonParser p, JsonNode node, LicenseChoice licenseChoice, DeserializationContext ctxt) throws IOException {
        JsonParser expressionParser = node.traverse(p.getCodec());
        expressionParser.nextToken();
        Expression expression = this.expressionDeserializer.deserialize(expressionParser, ctxt);
        licenseChoice.setExpression(expression);
    }
}

