/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.util.EnumSet;
import org.cyclonedx.Format;

public enum Version {
    VERSION_10("http://cyclonedx.org/schema/bom/1.0", "1.0", 1.0, EnumSet.of(Format.XML)),
    VERSION_11("http://cyclonedx.org/schema/bom/1.1", "1.1", 1.1, EnumSet.of(Format.XML)),
    VERSION_12("http://cyclonedx.org/schema/bom/1.2", "1.2", 1.2, EnumSet.of(Format.XML, Format.JSON)),
    VERSION_13("http://cyclonedx.org/schema/bom/1.3", "1.3", 1.3, EnumSet.of(Format.XML, Format.JSON)),
    VERSION_14("http://cyclonedx.org/schema/bom/1.4", "1.4", 1.4, EnumSet.of(Format.XML, Format.JSON)),
    VERSION_15("http://cyclonedx.org/schema/bom/1.5", "1.5", 1.5, EnumSet.of(Format.XML, Format.JSON)),
    VERSION_16("http://cyclonedx.org/schema/bom/1.6", "1.6", 1.6, EnumSet.of(Format.XML, Format.JSON));

    private final String namespace;
    private final String versionString;
    private final double version;
    private final EnumSet<Format> formats;

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public double getVersion() {
        return this.version;
    }

    public EnumSet<Format> getFormats() {
        return this.formats;
    }

    private Version(String namespace, String versionString, double version, EnumSet<Format> formats) {
        this.namespace = namespace;
        this.versionString = versionString;
        this.version = version;
        this.formats = formats;
    }

    public static Version fromVersionString(String versionString) {
        if (versionString != null) {
            switch (versionString) {
                case "1.0": {
                    return VERSION_10;
                }
                case "1.1": {
                    return VERSION_11;
                }
                case "1.2": {
                    return VERSION_12;
                }
                case "1.3": {
                    return VERSION_13;
                }
                case "1.4": {
                    return VERSION_14;
                }
                case "1.5": {
                    return VERSION_15;
                }
                case "1.6": {
                    return VERSION_16;
                }
            }
        }
        return null;
    }
}

