/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.testutil.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.testutil.example.Example;

public class ExampleReader {
    private static final Pattern SECTION_PATTERN = Pattern.compile("#{1,6} *(.*)");
    private static final String EXAMPLE_START_MARKER = "```````````````````````````````` example";
    private final InputStream inputStream;
    private final String filename;
    private State state = State.BEFORE;
    private String section;
    private String info = "";
    private StringBuilder source;
    private StringBuilder html;
    private int exampleNumber = 0;
    private List<Example> examples = new ArrayList<Example>();

    private ExampleReader(InputStream stream, String filename) {
        this.inputStream = stream;
        this.filename = filename;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Example> readExamples(URL url) {
        try (InputStream stream = url.openStream();){
            List<Example> list = new ExampleReader(stream, new File(url.getPath()).getName()).read();
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readExampleSources(URL url) {
        List<Example> examples = ExampleReader.readExamples(url);
        ArrayList<String> result = new ArrayList<String>();
        for (Example example : examples) {
            result.add(example.getSource());
        }
        return result;
    }

    private List<Example> read() throws IOException {
        this.resetContents();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        return this.examples;
    }

    private void processLine(String line) {
        switch (this.state) {
            case BEFORE: {
                Matcher matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    this.section = matcher.group(1);
                    this.exampleNumber = 0;
                }
                if (!line.startsWith(EXAMPLE_START_MARKER)) break;
                this.info = line.substring(EXAMPLE_START_MARKER.length()).trim();
                this.state = State.SOURCE;
                ++this.exampleNumber;
                break;
            }
            case SOURCE: {
                if (line.equals(".")) {
                    this.state = State.HTML;
                    break;
                }
                String processedLine = line.replace('\u2192', '\t');
                this.source.append(processedLine).append('\n');
                break;
            }
            case HTML: {
                if (line.equals("````````````````````````````````")) {
                    this.state = State.BEFORE;
                    this.examples.add(new Example(this.filename, this.section, this.info, this.exampleNumber, this.source.toString(), this.html.toString()));
                    this.resetContents();
                    break;
                }
                this.html.append(line).append('\n');
            }
        }
    }

    private void resetContents() {
        this.source = new StringBuilder();
        this.html = new StringBuilder();
    }

    private static enum State {
        BEFORE,
        SOURCE,
        HTML;

    }
}

