/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jirareport;

import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.codehaus.swizzle.jirareport.MissingParamsException;
import org.codehaus.swizzle.jirareport.Param;

public class ParamsUtil {
    private final List missingArgs = new ArrayList();
    private final VelocityContext context;

    public ParamsUtil(VelocityContext context) {
        this.context = context;
    }

    public void required(String param, String regex, String description) {
        Object object = this.context.get(param);
        if (object == null) {
            this.missingArgs.add(new Param(Param.MISSING, param, regex, description));
        } else if (!object.toString().matches(regex)) {
            this.missingArgs.add(new Param(Param.INVALID, param, regex, description));
        }
    }

    public void validate() throws IllegalArgumentException {
        if (this.missingArgs.size() == 0) {
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("Invalid or missing arguments.");
        sb.append(lineSeparator);
        for (int i = 0; i < this.missingArgs.size(); ++i) {
            Param param = (Param)this.missingArgs.get(i);
            sb.append("  [");
            sb.append(param.getStatus());
            sb.append("]    ");
            sb.append(param.getName());
            sb.append("    : ");
            sb.append(param.getDescription());
            sb.append(". Must Match Pattern '");
            sb.append(param.getRegex());
            sb.append("'");
            sb.append(lineSeparator);
        }
        throw new MissingParamsException(sb.toString(), this.missingArgs.toArray(new Param[0]));
    }
}

