/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Sonar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateCenter {
    private Sonar sonar = new Sonar();
    private Set<Plugin> plugins = new HashSet<Plugin>();
    private Date date;

    public UpdateCenter() {
        this(new Date());
    }

    public UpdateCenter(Date date) {
        this.date = date;
    }

    public Set<Plugin> getPlugins() {
        return this.plugins;
    }

    public Plugin getPlugin(String key) {
        for (Plugin plugin : this.plugins) {
            if (!StringUtils.equals((String)key, (String)plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }

    public UpdateCenter setPlugins(Collection<Plugin> plugins) {
        this.plugins.clear();
        this.plugins.addAll(plugins);
        return this;
    }

    public UpdateCenter addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public Sonar getSonar() {
        return this.sonar;
    }

    public UpdateCenter setSonar(Sonar sonar) {
        this.sonar = sonar;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public UpdateCenter setDate(Date date) {
        this.date = date;
        return this;
    }
}

