/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.TempFileUtils;

public final class ZipUtils {
    private ZipUtils() {
    }

    @Deprecated
    public static File unzipToTempDir(File zip) throws IOException {
        File toDir = TempFileUtils.createTempDirectory();
        ZipUtils.unzip(zip, toDir);
        return toDir;
    }

    public static File unzip(File zip, File toDir) throws IOException {
        ZipUtils.unzip(zip, toDir, new ZipEntryFilter(){

            public boolean accept(ZipEntry entry) {
                return true;
            }
        });
        return toDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(File zip, File toDir, ZipEntryFilter filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir((File)toDir);
        }
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!filter.accept(entry)) continue;
                File to = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    if (to.exists() || to.mkdirs()) continue;
                    throw new IOException("Error creating directory: " + to);
                }
                File parent = to.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Error creating directory: " + parent);
                }
                FileOutputStream fos = new FileOutputStream(to);
                InputStream input = null;
                try {
                    input = zipFile.getInputStream(entry);
                    IOUtils.copy((InputStream)input, (OutputStream)fos);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                    IOUtils.closeQuietly((OutputStream)fos);
                }
            }
            File file = toDir;
            return file;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File dir, File zip) throws IOException {
        FileOutputStream out = null;
        ZipOutputStream zout = null;
        try {
            out = FileUtils.openOutputStream((File)zip);
            zout = new ZipOutputStream(out);
            ZipUtils.zip(dir, zout);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zout);
            IOUtils.closeQuietly((OutputStream)out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zout);
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static void _zip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        out.putNextEntry(zentry);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _zip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = entryName + '/';
            ZipEntry zentry = new ZipEntry(entryName);
            out.putNextEntry(zentry);
            out.closeEntry();
            File[] files = file.listFiles();
            int i = 0;
            int len = files.length;
            while (i < len) {
                ZipUtils._zip(entryName + files[i].getName(), files[i], out);
                ++i;
            }
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            ZipUtils._zip(entryName, in, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private static void zip(File file, ZipOutputStream out) throws IOException {
        for (File child : file.listFiles()) {
            String name = child.getName();
            ZipUtils._zip(name, child, out);
        }
    }

    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }
}

