/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonar.home.cache.FileCache;
import org.sonar.home.cache.FileCacheBuilder;
import org.sonar.home.log.StandardLog;
import org.sonar.runner.impl.JarExtractor;
import org.sonar.runner.impl.ServerConnection;

class Jars35 {
    private static final String BOOTSTRAP_INDEX_PATH = "/batch_bootstrap/index";
    static final String BATCH_PATH = "/batch/";
    private final FileCache fileCache;
    private final ServerConnection connection;
    private final JarExtractor jarExtractor;

    Jars35(ServerConnection conn, JarExtractor jarExtractor) {
        this.fileCache = new FileCacheBuilder().setLog(new StandardLog()).build();
        this.connection = conn;
        this.jarExtractor = jarExtractor;
    }

    Jars35(FileCache fileCache, ServerConnection conn, JarExtractor jarExtractor) {
        this.fileCache = fileCache;
        this.connection = conn;
        this.jarExtractor = jarExtractor;
    }

    List<File> download() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(this.jarExtractor.extractToTemp("sonar-runner-batch"));
        files.addAll(this.dowloadFiles());
        return files;
    }

    private List<File> dowloadFiles() {
        try {
            ArrayList<File> files = new ArrayList<File>();
            String libs = this.connection.downloadString(BOOTSTRAP_INDEX_PATH);
            String[] lines = libs.split("[\r\n]+");
            BatchFileDownloader batchFileDownloader = new BatchFileDownloader(this.connection);
            for (String line : lines) {
                if ("".equals(line = line.trim())) continue;
                String[] libAndHash = line.split("\\|");
                String filename = libAndHash[0];
                String hash = libAndHash.length > 0 ? libAndHash[1] : "";
                files.add(this.fileCache.get(filename, hash, batchFileDownloader));
            }
            return files;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to download libraries from server", e);
        }
    }

    static class BatchFileDownloader
    implements FileCache.Downloader {
        private final ServerConnection connection;

        BatchFileDownloader(ServerConnection conn) {
            this.connection = conn;
        }

        @Override
        public void download(String filename, File toFile) throws IOException {
            this.connection.download(Jars35.BATCH_PATH + filename, toFile);
        }
    }
}

