/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.sonar.report.pdf.entity.Project;

public class Header
extends PdfPageEventHelper {
    private URL logo;
    private Project project;

    public Header(URL logo, Project project) {
        this.logo = logo;
        this.project = project;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            Image logoImage = Image.getInstance((URL)this.logo);
            Rectangle page = document.getPageSize();
            PdfPTable head = new PdfPTable(4);
            head.getDefaultCell().setVerticalAlignment(5);
            head.getDefaultCell().setHorizontalAlignment(1);
            head.addCell(logoImage);
            Phrase projectName = new Phrase(this.project.getName(), FontFactory.getFont((String)"Courier", (float)12.0f, (int)0, (Color)Color.GRAY));
            Phrase phrase = new Phrase("Sonar PDF Report", FontFactory.getFont((String)"Courier", (float)12.0f, (int)0, (Color)Color.GRAY));
            head.getDefaultCell().setColspan(2);
            head.addCell(phrase);
            head.getDefaultCell().setColspan(1);
            head.addCell(projectName);
            head.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
            head.writeSelectedRows(0, -1, document.leftMargin(), page.getHeight() - 20.0f, writer.getDirectContent());
            head.setSpacingAfter(10.0f);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

