/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.resource.loader.URLPlexusResource;

@Component(role=ResourceLoader.class, hint="url", instantiationStrategy="per-lookup")
public class URLResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "url";
    protected Map<String, String> templateRoots = new HashMap<String, String>();

    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        block11: {
            if (name == null || name.length() == 0) {
                throw new ResourceNotFoundException("URLResourceLoader : No template name provided");
            }
            for (String path : this.paths) {
                try {
                    URL u = new URL(path + name);
                    final InputStream inputStream = u.openStream();
                    if (inputStream == null) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("URLResourceLoader: Found '" + name + "' at '" + path + "'");
                    }
                    this.templateRoots.put(name, path);
                    return new URLPlexusResource(u){
                        private boolean useSuper;

                        public synchronized InputStream getInputStream() throws IOException {
                            if (!this.useSuper) {
                                this.useSuper = true;
                                return inputStream;
                            }
                            return super.getInputStream();
                        }
                    };
                }
                catch (MalformedURLException mue) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("URLResourceLoader: No valid URL '" + path + name + '\'');
                }
                catch (IOException ioe) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("URLResourceLoader: Exception when looking for '" + name + "' at '" + path + "'", (Throwable)ioe);
                }
            }
            try {
                URL u = new URL(name);
                final InputStream inputStream = u.openStream();
                if (inputStream != null) {
                    return new URLPlexusResource(u){
                        private boolean useSuper;

                        public synchronized InputStream getInputStream() throws IOException {
                            if (!this.useSuper) {
                                this.useSuper = true;
                                return inputStream;
                            }
                            return super.getInputStream();
                        }
                    };
                }
            }
            catch (MalformedURLException mue) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("URLResourceLoader: No valid URL '" + name + '\'');
                }
            }
            catch (IOException ioe) {
                if (!this.getLogger().isDebugEnabled()) break block11;
                this.getLogger().debug("URLResourceLoader: Exception when looking for '" + name + '\'', (Throwable)ioe);
            }
        }
        throw new ResourceNotFoundException(name);
    }
}

