/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.cdc.gleaner.ClassComponentGleaner;
import org.codehaus.plexus.component.repository.cdc.ComponentDescriptor;
import org.codehaus.plexus.maven.plugin.ComponentDescriptorExtractorSupport;
import org.codehaus.plexus.util.DirectoryScanner;

public class ClassComponentDescriptorExtractor
extends ComponentDescriptorExtractorSupport {
    private ClassComponentGleaner gleaner;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassComponentDescriptorExtractor(ClassComponentGleaner gleaner) {
        this.gleaner = gleaner;
    }

    public ClassComponentDescriptorExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List extract(MavenProject project, String scope, ComponentDescriptor[] roleDefaults) throws Exception {
        File classesDir;
        List classpath;
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && scope == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && roleDefaults == null) {
            throw new AssertionError();
        }
        if (this.gleaner == null) {
            throw new IllegalStateException("Gleaner is not bound");
        }
        this.log.debug("Gleaner: " + this.gleaner + ", scope: " + scope);
        if ("compile".equals(scope)) {
            classpath = project.getCompileClasspathElements();
            classesDir = new File(project.getBuild().getOutputDirectory());
        } else if ("test".equals(scope)) {
            classpath = project.getTestClasspathElements();
            classesDir = new File(project.getBuild().getTestOutputDirectory());
        } else {
            throw new IllegalArgumentException("Invalid scope: " + scope);
        }
        if (!classesDir.exists()) {
            this.log.warn("Missing classes directory: {}", (Object)classesDir);
            return Collections.EMPTY_LIST;
        }
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = this.createClassLoader(classpath);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            List list = this.extract(classesDir, cl, this.getDefaultsByRole(roleDefaults));
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
    }

    private ClassLoader createClassLoader(List elements) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            try {
                list.add(new File(filename).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid classpath entry: " + filename, (Exception)e);
            }
        }
        URL[] urls = list.toArray(new URL[list.size()]);
        this.log.debug("Classpath:");
        for (int i = 0; i < urls.length; ++i) {
            this.log.debug("    " + urls[i]);
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private List extract(File classesDir, ClassLoader cl, Map defaultsByRole) throws Exception {
        if (!$assertionsDisabled && classesDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && defaultsByRole == null) {
            throw new AssertionError();
        }
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classesDir);
        scanner.addDefaultExcludes();
        scanner.setIncludes(new String[]{"**/*.class"});
        this.log.debug("Scanning for classes in: " + classesDir);
        scanner.scan();
        String[] includes = scanner.getIncludedFiles();
        for (int i = 0; i < includes.length; ++i) {
            String className = includes[i].substring(0, includes[i].lastIndexOf(".class")).replace('\\', '.').replace('/', '.');
            this.log.debug("Loading class: " + className);
            try {
                Class<?> type = cl.loadClass(className);
                this.log.debug("Gleaning from: " + type);
                ComponentDescriptor descriptor = this.gleaner.glean(type);
                if (descriptor == null) continue;
                this.applyDefaults(descriptor, defaultsByRole);
                descriptors.add(descriptor);
                continue;
            }
            catch (VerifyError e) {
                this.log.error("Failed to load class: " + className + "; cause: " + e);
            }
        }
        this.log.debug("Extracted " + descriptors.size() + " descriptor(s)");
        return descriptors;
    }

    static {
        $assertionsDisabled = !ClassComponentDescriptorExtractor.class.desiredAssertionStatus();
    }
}

