/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.maven.plugin.report.ComponentSet;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PlexusComponentsReport
extends AbstractMavenReport {
    private File componentsXml;
    private MavenProject project;
    private SiteRenderer siteRenderer;
    private String outputDirectory;
    private String javaDocDestDir;
    private String jxrDestDir;

    public String getOutputName() {
        return "plexus/plexus-components";
    }

    public String getName(Locale locale) {
        return "Plexus Components";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        return "Plexus components report description";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean canGenerateReport() {
        return this.componentsXml.isFile();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Document document;
        String title = "Plexus Components Report";
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        try {
            document = new SAXBuilder().build(this.componentsXml);
        }
        catch (JDOMException e) {
            throw new MavenReportException("Error while building document of " + this.componentsXml.getAbsolutePath() + ".", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MavenReportException("Error while building document of " + this.componentsXml.getAbsolutePath() + ".", (Exception)e);
        }
        if (document.getRootElement().getName().equals("component-set")) {
            ComponentSet componentSet = new ComponentSet(document.getRootElement());
            componentSet.print(sink, this.javaDocDestDir, this.jxrDestDir);
        }
        sink.body_();
        sink.flush();
    }
}

