/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.maven.plugin.report.Component;
import org.jdom.Element;

public class Components {
    private List components = new ArrayList();

    public Components(Element element) {
        Iterator it = element.getChildren("component").iterator();
        while (it.hasNext()) {
            Element component = (Element)it.next();
            this.components.add(new Component(component));
        }
    }

    public void print(Sink sink, String javaDocDestDir, String jxrDestDir) {
        Component component;
        TreeSet<String> roles = new TreeSet<String>();
        TreeSet<Component> emptyList = new TreeSet<Component>();
        TreeMap<String, ArrayList<Component>> roleMap = new TreeMap<String, ArrayList<Component>>();
        Iterator<Object> it = this.components.iterator();
        while (it.hasNext()) {
            component = (Component)it.next();
            roles.add(component.getRole());
            if (!component.hasRoleHint()) {
                emptyList.add(component);
                continue;
            }
            ArrayList<Component> list = (ArrayList<Component>)roleMap.get(component.getRole());
            if (list == null) {
                list = new ArrayList<Component>();
                roleMap.put(component.getRole(), list);
            }
            list.add(component);
        }
        sink.section2();
        sink.sectionTitle2();
        sink.text("Index");
        sink.sectionTitle2_();
        sink.section2_();
        sink.paragraph();
        it = roles.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            sink.link("#" + role);
            sink.text(role);
            sink.link_();
            sink.lineBreak();
        }
        sink.paragraph_();
        sink.section2();
        sink.sectionTitle2();
        sink.text("Components without role-hint");
        sink.sectionTitle2_();
        sink.section2_();
        it = emptyList.iterator();
        while (it.hasNext()) {
            component = (Component)it.next();
            sink.anchor(component.getRole());
            sink.paragraph();
            component.print(sink, javaDocDestDir, jxrDestDir);
            sink.paragraph_();
            sink.anchor_();
        }
        it = roleMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            sink.section2();
            sink.sectionTitle2();
            sink.anchor((String)entry.getKey());
            sink.text("Components implementing " + entry.getKey());
            sink.anchor_();
            sink.sectionTitle2_();
            sink.section2_();
            Iterator j = ((List)entry.getValue()).iterator();
            while (j.hasNext()) {
                Component component2 = (Component)j.next();
                sink.paragraph();
                component2.print(sink, javaDocDestDir, jxrDestDir);
                sink.paragraph_();
            }
        }
    }
}

