/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.apache.xmlbeans.impl.tool.SchemaCompiler;
import org.codehaus.mojo.xmlbeans.AbstractXmlBeansPlugin;
import org.codehaus.mojo.xmlbeans.XmlBeansException;
import org.codehaus.plexus.util.FileUtils;

public class TestXmlBeansMojo
extends AbstractXmlBeansPlugin {
    protected File schemaDirectory;
    private List testXsdJars;
    private File generatedSchemaDirectory;
    protected File classGenerationDirectory;
    protected File sourceGenerationDirectory;
    protected File staleFile;
    protected File defaultXmlConfigDir;

    protected void updateProject(MavenProject project, SchemaCompiler.Parameters compilerParams) throws DependencyResolutionRequiredException, XmlBeansException {
        project.addTestCompileSourceRoot(compilerParams.getSrcDir().getAbsolutePath());
        File outputDirectory = new File(project.getBuild().getTestOutputDirectory());
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.getLog().debug((CharSequence)"Copying generated test classes into the output directory.");
        try {
            FileUtils.copyDirectoryStructure((File)compilerParams.getClassesDir(), (File)outputDirectory);
        }
        catch (IOException ex) {
            throw new XmlBeansException(XmlBeansException.COPY_CLASSES, outputDirectory.getAbsolutePath(), (Throwable)ex);
        }
    }

    public File getBaseDir() {
        return this.getSchemaDirectory();
    }

    public final File getGeneratedClassesDirectory() {
        return this.classGenerationDirectory;
    }

    public final File getGeneratedSourceDirectory() {
        return this.sourceGenerationDirectory;
    }

    public File getStaleFile() {
        return this.staleFile;
    }

    public File getDefaultXmlConfigDir() {
        return this.defaultXmlConfigDir;
    }

    public File getSchemaDirectory() {
        return this.schemaDirectory;
    }

    protected List getXsdJars() {
        if (this.testXsdJars == null) {
            this.testXsdJars = new ArrayList();
        }
        return this.testXsdJars;
    }

    protected File getGeneratedSchemaDirectory() {
        return this.generatedSchemaDirectory;
    }
}

