/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest.components;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.types.Path;

public class AntExecutor {
    public AntExecutor(File antFile, Properties userProperties, MavenProject mavenProject, List artifacts, String target) throws BuildException, DependencyResolutionRequiredException {
        File antBaseDir = antFile.getParentFile();
        Project antProject = new Project();
        antProject.init();
        antProject.addBuildListener((BuildListener)this.createLogger());
        antProject.setBaseDir(antBaseDir);
        ProjectHelper2.configureProject((Project)antProject, (File)antFile);
        Enumeration<Object> propertyKeys = userProperties.keys();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            String value = userProperties.getProperty(key);
            antProject.setUserProperty(key, value);
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference("maven.dependency.classpath", (Object)p);
        antProject.addReference("maven.compile.classpath", (Object)p);
        p = new Path(antProject);
        p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference("maven.runtime.classpath", (Object)p);
        p = new Path(antProject);
        p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference("maven.test.classpath", (Object)p);
        antProject.addReference("maven.plugin.classpath", (Object)this.getPathFromArtifacts(artifacts, antProject));
        antProject.executeTarget(target);
    }

    private BuildLogger createLogger() {
        DefaultLogger logger = new DefaultLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        logger.setEmacsMode(false);
        return logger;
    }

    public Path getPathFromArtifacts(Collection artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Artifact a : artifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }
}

