/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webtest.AbstractWebtestMojo;
import org.codehaus.mojo.webtest.components.ReportCollector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebtestVerifyResultMojo
extends AbstractWebtestMojo {
    public void execute() throws MojoExecutionException {
        int nrOfFailures = 0;
        int nrOfTests = 0;
        ReportCollector walker = new ReportCollector("WebTestReport.xml");
        File[] currResultFileList = walker.run(this.getResultpath());
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            for (int i = 0; i < currResultFileList.length; ++i) {
                File currResultFile = currResultFileList[i];
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(currResultFile);
                NodeList testResultList = document.getElementsByTagName("testresult");
                nrOfTests += testResultList.getLength();
                for (int j = 0; j < testResultList.getLength(); ++j) {
                    Node testResultNode = testResultList.item(j);
                    String testResult = testResultNode.getAttributes().getNamedItem("successful").getNodeValue();
                    if (testResult.equalsIgnoreCase("yes") || testResult.equalsIgnoreCase("true")) continue;
                    ++nrOfFailures;
                }
            }
            if (nrOfFailures > 0) {
                String msg = "There were test failures : " + nrOfFailures + "/" + nrOfTests;
                throw new MojoExecutionException(msg);
            }
            this.getLog().info((CharSequence)("There were no test failures : " + nrOfFailures + "/" + nrOfTests));
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Executing webtest:verify failed";
            throw new MojoExecutionException(msg, e);
        }
    }
}

