/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.ArrayList;

public class VerifyHeader
extends AbstractVerifyTextStep {
    private String fHeaderName;

    public void setName(String name) {
        this.fHeaderName = name;
    }

    public String getName() {
        return this.fHeaderName;
    }

    public void doExecute() {
        WebResponse response = this.getContext().getCurrentResponse().getWebResponse();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (NameValuePair nv : response.getResponseHeaders()) {
            if (!this.getName().equals(nv.getName())) continue;
            if (this.verifyText(nv.getValue())) {
                return;
            }
            headers.add(nv);
        }
        if (headers.isEmpty()) {
            throw new StepFailedException("No header found with name \"" + this.fHeaderName + "\"!");
        }
        if (headers.size() == 1) {
            NameValuePair first = (NameValuePair)headers.get(0);
            throw new StepFailedException("Wrong header value found for header \"" + this.fHeaderName + "\"!", this.getText(), first.getValue());
        }
        throw new StepFailedException("None of the headers \"" + this.fHeaderName + "\" has the right value: " + ((Object)headers).toString());
    }

    protected void verifyParameters() {
        this.nullParamCheck(this.fHeaderName, "name");
        this.nullResponseCheck();
    }

    public void setText(String text) {
        super.setText(text);
    }

    public void addText(String text) {
        text = this.getProject().replaceProperties(text);
        int p = text.indexOf(58);
        if (p != -1) {
            String name = text.substring(0, p).trim();
            this.setName(name);
            String value = text.substring(p + 1).trim();
            this.setText(value);
        }
    }
}

