/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.interfaces.IConnectionInitializer;
import com.canoo.webtest.security.ConnectionInitializationException;
import com.canoo.webtest.steps.AbstractBrowserAction;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebRequest;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.http.client.CredentialsProvider;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class TargetHelper
implements Serializable {
    private static final Logger LOG = Logger.getLogger(TargetHelper.class);
    public static final String CONNECTION_INITIALIZER_KEY = "webtest.connectioninitializer";
    private String fUserName;
    private String fPassword;
    private final AbstractBrowserAction fStep;

    public TargetHelper(AbstractBrowserAction step) {
        this.fStep = step;
    }

    public void setUsername(String userName) {
        this.fUserName = userName;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public Page getResponse(Context context, String strUrl) throws IOException, SAXException {
        LOG.info((Object)("getting response for url: " + strUrl));
        this.prepareConversationIfNeeded(context);
        URL url = new URL(strUrl);
        return context.getWebClient().getPage(url);
    }

    public Page getResponse(Context context, WebRequest settings) throws IOException, SAXException {
        LOG.info((Object)("getting response for url: " + settings.getUrl()));
        this.prepareConversationIfNeeded(context);
        return context.getWebClient().getPage(settings);
    }

    protected void prepareConversationIfNeeded(Context context) {
        Configuration config;
        String customInitializerClassName;
        if (context.isPrepared()) {
            LOG.debug((Object)"Conversation already prepared - attempting to skip preparation");
            if (!this.hasSuppliedCredentials()) {
                return;
            }
            if (this.hasSuppliedCredentials() && this.fUserName.equals(context.getSavedUserName()) && this.fPassword.equals(context.getSavedPassword())) {
                return;
            }
            LOG.debug((Object)"Conversation already prepared - but username and password have changed - continuing preparation");
        }
        if (this.hasSuppliedCredentials()) {
            LOG.info((Object)("Setting password for username: " + this.fUserName));
            DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider();
            context.getWebClient().setCredentialsProvider((CredentialsProvider)credentialsProvider);
            credentialsProvider.addCredentials(this.fUserName, this.fPassword);
            context.setSavedUserName(this.fUserName);
            context.setSavedPassword(this.fPassword);
        }
        if ((customInitializerClassName = (config = context.getConfig()).getExternalProperty(CONNECTION_INITIALIZER_KEY)) != null) {
            this.invokeCustomInitializer(context, customInitializerClassName);
        }
        context.setPrepared(true);
    }

    private boolean hasSuppliedCredentials() {
        return this.fUserName != null && this.fPassword != null;
    }

    protected void invokeCustomInitializer(Context context, String customInitializerClassName) {
        LOG.info((Object)("Using custom initializer: " + customInitializerClassName));
        try {
            Object object = Class.forName(customInitializerClassName).newInstance();
            IConnectionInitializer customInitializer = (IConnectionInitializer)object;
            customInitializer.initializeConnection(context.getConfig());
        }
        catch (ConnectionInitializationException e) {
            StepExecutionException throwme = new StepExecutionException("ConnectionInitializer raised exception: " + e.getMessage(), this.fStep);
            throw (RuntimeException)((Throwable)((Object)throwme)).fillInStackTrace();
        }
        catch (Exception e) {
            LOG.info((Object)"Root exception from Connection Initializer", (Throwable)e);
            StepExecutionException throwme = new StepExecutionException("Exception raised while trying to create custom ConnectionInitializer <" + customInitializerClassName + "> / Exception: " + e, this.fStep);
            throw (RuntimeException)((Throwable)((Object)throwme)).fillInStackTrace();
        }
    }
}

