/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.boundary.HtmlUnitBoundary;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.request.AbstractTargetAction;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import javax.xml.xpath.XPathException;
import org.apache.log4j.Logger;

public abstract class AbstractIdOrLabelTarget
extends AbstractTargetAction {
    private static final Logger LOG = Logger.getLogger(AbstractIdOrLabelTarget.class);
    private String fLabel;
    private String fHtmlId;
    private String fXPath;

    public void setLabel(String newLabel) {
        this.fLabel = newLabel;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setHtmlId(String htmlId) {
        this.fHtmlId = htmlId;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setXpath(String xpath) {
        this.fXPath = xpath;
    }

    public String getXpath() {
        return this.fXPath;
    }

    protected HtmlElement findClickableElement(HtmlPage page) throws XPathException {
        if (this.getHtmlId() != null) {
            return this.findClickableElementById(page);
        }
        if (this.getXpath() != null) {
            return this.findClickableElementByXPath(page);
        }
        return this.findClickableElementByAttribute(page);
    }

    protected abstract HtmlElement findClickableElementByAttribute(HtmlPage var1);

    HtmlElement findClickableElementById(HtmlPage page) {
        HtmlElement elt;
        LOG.debug((Object)("Looking for html element with id: " + this.getHtmlId()));
        try {
            elt = page.getHtmlElementById(this.getHtmlId());
        }
        catch (ElementNotFoundException e) {
            LOG.info((Object)("No html element found with id: " + this.getHtmlId()));
            return null;
        }
        return this.checkFoundElement(elt);
    }

    HtmlElement findClickableElementByXPath(HtmlPage page) throws XPathException {
        LOG.debug((Object)("Looking for html element with xpath: " + this.getXpath()));
        Object node = HtmlUnitBoundary.trySelectSingleNodeByXPath(this.getXpath(), (Page)page, this);
        LOG.debug((Object)("XPath evaluates to: " + node));
        if (node == null) {
            return null;
        }
        if (node instanceof HtmlElement) {
            return this.checkFoundElement((HtmlElement)node);
        }
        throw new StepFailedException("The xpath doesn't select an HTML element but a '" + node.getClass() + "'");
    }

    abstract HtmlElement checkFoundElement(HtmlElement var1) throws StepFailedException;
}

