/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.emailtest.AbstractStoreStep;
import com.canoo.webtest.plugins.emailtest.ISingleMessageStep;
import com.canoo.webtest.util.ConversionUtil;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;

public abstract class AbstractMessageStoreStep
extends AbstractStoreStep
implements ISingleMessageStep {
    private String fMessageId;

    public void setMessageId(String id) {
        this.fMessageId = id;
    }

    public String getMessageId() {
        return this.fMessageId;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.fMessageId, "messageId", true);
    }

    protected String processContent(Folder folder) throws MessagingException {
        int id = ConversionUtil.convertToInt(this.getMessageId(), 0);
        Message message = this.getHelper().getMessage(id, folder);
        if (message == null) {
            throw new StepFailedException("Could not find message with id '" + id + "' on server.", this);
        }
        return this.performOperation(message);
    }

    protected abstract String performOperation(Message var1) throws MessagingException;
}

