/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.WebClientContext;
import com.canoo.webtest.extension.AbstractProcessFiltersStep;
import com.canoo.webtest.extension.VerifyContentBinDiff;
import com.canoo.webtest.extension.VerifyContentDiff;
import com.canoo.webtest.extension.VerifyContentRegexPerLineDiff;
import com.canoo.webtest.extension.VerifyContentTextDiff;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.FileUtil;
import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VerifyContent
extends AbstractProcessFiltersStep {
    private static final Logger LOG = Logger.getLogger(VerifyContent.class);
    private File fReferenceFile;
    private boolean fReadFiltered = true;
    private static final String DIFF_MODE_AUTO = "auto";
    private static final String DIFF_MODE_BIN = "bin";
    private static final String DIFF_MODE_TEXT = "text";
    private static final String DIFF_MODE_REGEXPERLINE = "regexperline";
    private String fMode = "auto";

    public File getReferenceFile() {
        return this.fReferenceFile;
    }

    public void setMode(String mode) {
        this.fMode = mode;
    }

    public String getMode() {
        return this.fMode;
    }

    public void setReferenceFile(File file) {
        this.fReferenceFile = file;
    }

    public boolean isReadFiltered() {
        return this.fReadFiltered;
    }

    public void setReadFiltered(boolean readFiltered) {
        this.fReadFiltered = readFiltered;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getReferenceFile(), "referenceFile");
        if (!this.getReferenceFile().exists()) {
            throw new StepFailedException("Reference file doesn't exist: " + this.getReferenceFile().getAbsolutePath());
        }
        String mode = this.getMode().toLowerCase();
        Object[] allowedModes = new String[]{DIFF_MODE_AUTO, DIFF_MODE_BIN, DIFF_MODE_TEXT, DIFF_MODE_REGEXPERLINE};
        if (!ArrayUtils.contains((Object[])allowedModes, (Object)mode)) {
            throw new StepExecutionException("Unallowed diff mode >" + this.getMode() + "<. " + "Allowed modes are " + ArrayUtils.toString((Object)allowedModes) + ".", this);
        }
    }

    public void doExecute() throws Exception {
        WebClientContext.StoredResponses origResponses = this.getContext().getResponses();
        String result = this.diffContentWithExpected();
        this.getContext().restoreResponses(origResponses);
        if (!StringUtils.isEmpty((String)result)) {
            StepFailedException e = new StepFailedException("Current response and the reference differ.", this);
            e.addDetail("diff", result);
            throw e;
        }
    }

    private String diffContentWithExpected() throws IOException {
        List steps = this.getSteps();
        Context context = this.getContext();
        this.applyTableFilterIfNeeded(context);
        this.applyExtractionIfNeeded(context);
        for (Step step : steps) {
            this.executeContainedStep(step);
        }
        WebClientContext.StoredResponses srcResponses = context.getResponses();
        Page actualPage = context.getCurrentResponse();
        WebResponse actualResponse = actualPage.getWebResponse();
        LOG.debug((Object)("Processig reference file: " + this.getReferenceFile()));
        WebClientContext.StoredResponses referenceResponses = this.preProcessFiles(this.getReferenceFile(), context);
        if (this.isReadFiltered()) {
            LOG.debug((Object)"Applying filter on reference file too");
            context.restoreResponses(referenceResponses);
            for (Step step : steps) {
                step.execute();
            }
            referenceResponses = context.getResponses();
            context.restoreResponses(srcResponses);
        }
        LOG.debug((Object)("Source: " + actualResponse.getContentType() + " (" + actualResponse.getWebRequest().getUrl() + ")"));
        context.restoreResponses(referenceResponses);
        Page referencePage = context.getCurrentResponse();
        WebResponse referenceResponse = referencePage.getWebResponse();
        LOG.debug((Object)("Reference: " + referenceResponse.getContentType() + " (" + referenceResponse.getWebRequest().getUrl() + ")"));
        return this.produceDiffMessage(actualPage, referencePage);
    }

    private WebClientContext.StoredResponses preProcessFiles(File destfile, Context context) {
        LOG.debug((Object)("Loading reference file: " + destfile));
        byte[] destBytes = FileUtil.readFileToByteArray(destfile, this);
        ContextHelper.defineAsCurrentResponse(context, destBytes, context.getCurrentResponse().getWebResponse().getContentType(), "http:" + this.getClass().getName());
        return context.getResponses();
    }

    private String produceDiffMessage(Page actualPage, Page referencePage) throws IOException {
        String labelReference = this.getReferenceFile().getAbsolutePath();
        String labelActual = "current response";
        if (!this.getSteps().isEmpty()) {
            labelActual = labelActual + " (filtered)";
            if (this.isReadFiltered()) {
                labelReference = labelReference + " (filtered)";
            }
        }
        VerifyContentDiff diff = this.getDiff(actualPage, referencePage);
        LOG.debug((Object)("Mode >" + this.getMode() + "<, using: " + diff));
        return diff.compare(referencePage.getWebResponse(), actualPage.getWebResponse(), labelReference, labelActual);
    }

    private VerifyContentDiff getDiff(Page actualPage, Page referencePage) {
        String mode = this.getMode().toLowerCase();
        if (DIFF_MODE_AUTO.equals(mode)) {
            mode = VerifyContent.isTextResponse(actualPage) && VerifyContent.isTextResponse(referencePage) ? DIFF_MODE_TEXT : DIFF_MODE_BIN;
        }
        if (DIFF_MODE_TEXT.equals(mode)) {
            return new VerifyContentTextDiff();
        }
        if (DIFF_MODE_REGEXPERLINE.equals(mode)) {
            return new VerifyContentRegexPerLineDiff();
        }
        return new VerifyContentBinDiff();
    }

    static boolean isTextResponse(Page _page) {
        return _page instanceof HtmlPage || _page instanceof TextPage || _page instanceof XmlPage || _page instanceof JavaScriptPage;
    }
}

