/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.boundary.StreamBoundary;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.AbstractProcessContentStep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StoreDigest
extends AbstractProcessContentStep {
    private String fAlgorithm;

    protected String processContent(Context context) {
        MessageDigest md = this.tryGetDigest();
        md.update(StreamBoundary.tryGetBytes(context, this));
        byte[] digest = md.digest();
        return StoreDigest.hexRepresentation(digest);
    }

    private MessageDigest tryGetDigest() {
        try {
            return MessageDigest.getInstance(this.getType() == null ? "SHA-1" : this.getType());
        }
        catch (NoSuchAlgorithmException e) {
            throw new StepFailedException("No such message digest algorithm '" + this.getType() + "' available.", this);
        }
    }

    public static String hexRepresentation(byte[] digest) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            hexString.append(Integer.toHexString(0xFF & b));
            hexString.append(" ");
        }
        return hexString.toString().trim();
    }

    public void setType(String value) {
        this.fAlgorithm = value;
    }

    public String getType() {
        return this.fAlgorithm;
    }
}

