/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.AbstractBaseJnlpMojo;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.mojo.webstart.JnlpFile;
import org.codehaus.mojo.webstart.generator.GeneratorExtraConfig;
import org.codehaus.mojo.webstart.generator.JarResourcesGenerator;
import org.codehaus.mojo.webstart.generator.VersionXmlGenerator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class JnlpDownloadServletMojo
extends AbstractBaseJnlpMojo {
    private MavenProject project;
    private ArtifactMetadataSource artifactMetadataSource;
    private String outputDirectoryName;
    private List jnlpFiles;
    private List commonJarResources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfiguration();
        try {
            this.copyResources(this.getResourcesDirectory(), this.getWorkDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred attempting to copy resources to the working directory.", (Exception)e);
        }
        if (this.commonJarResources != null) {
            this.retrieveJarResources(this.commonJarResources);
        }
        Iterator itr = this.jnlpFiles.iterator();
        while (itr.hasNext()) {
            JnlpFile jnlpFile = (JnlpFile)itr.next();
            this.retrieveJarResources(jnlpFile.getJarResources());
        }
        this.signOrRenameJars();
        this.packJars();
        itr = this.jnlpFiles.iterator();
        while (itr.hasNext()) {
            this.generateJnlpFile((JnlpFile)itr.next(), this.getLibPath());
        }
        this.generateVersionXml();
        this.copyWorkingDirToOutputDir();
    }

    private void checkConfiguration() throws MojoExecutionException {
        if (this.jnlpFiles.isEmpty()) {
            throw new MojoExecutionException("Configuration error: At least one <jnlpFile> element must be specified");
        }
        if (this.jnlpFiles.size() == 1 && StringUtils.isEmpty((String)((JnlpFile)this.jnlpFiles.get(0)).getOutputFilename())) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified in single set of jnlpFiles. Using default output file name: launch.jnlp.");
            ((JnlpFile)this.jnlpFiles.get(0)).setOutputFilename("launch.jnlp");
        }
        Iterator itr = this.jnlpFiles.iterator();
        while (itr.hasNext()) {
            this.checkJnlpFileConfiguration((JnlpFile)itr.next());
        }
        this.checkForDuplicateJarResources();
        this.checkCommonJarResources();
        this.checkForUniqueJnlpFilenames();
        this.checkPack200();
    }

    private void checkJnlpFileConfiguration(JnlpFile jnlpFile) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)jnlpFile.getOutputFilename())) {
            throw new MojoExecutionException("Configuration error: An outputFilename must be specified for each jnlpFile element");
        }
        if (jnlpFile.getTemplateFilename() == null) {
            this.getLog().info((CharSequence)("No templateFilename found for " + jnlpFile.getOutputFilename() + ". Will use the default template."));
        } else {
            File templateFile = new File(this.getTemplateDirectory(), jnlpFile.getTemplateFilename());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP template does not exist: [" + templateFile + "]");
            }
        }
        this.checkJnlpJarResources(jnlpFile);
    }

    private void checkJnlpJarResources(JnlpFile jnlpFile) throws MojoExecutionException {
        List jnlpJarResources = jnlpFile.getJarResources();
        if (jnlpJarResources == null || jnlpJarResources.isEmpty()) {
            throw new MojoExecutionException("Configuration error: A non-empty <jarResources> element must be specified in the plugin configuration for the JNLP file named [" + jnlpFile.getOutputFilename() + "]");
        }
        Iterator itr = jnlpJarResources.iterator();
        ArrayList<JarResource> jarsWithMainClass = new ArrayList<JarResource>();
        while (itr.hasNext()) {
            JarResource jarResource = (JarResource)itr.next();
            this.checkMandatoryJarResourceFields(jarResource);
            if (jarResource.getMainClass() == null) continue;
            jnlpFile.setMainClass(jarResource.getMainClass());
            jarsWithMainClass.add(jarResource);
        }
        if (jarsWithMainClass.isEmpty()) {
            throw new MojoExecutionException("Configuration error: Exactly one <jarResource> element must be declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
        }
        if (jarsWithMainClass.size() > 1) {
            throw new MojoExecutionException("Configuration error: More than one <jarResource> element has been declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
        }
    }

    private void checkForDuplicateJarResources() throws MojoExecutionException {
        if (this.commonJarResources == null || this.commonJarResources.isEmpty()) {
            return;
        }
        Iterator jnlpFileItr = this.jnlpFiles.iterator();
        while (jnlpFileItr.hasNext()) {
            JnlpFile jnlpFile = (JnlpFile)jnlpFileItr.next();
            List jnlpJarResources = jnlpFile.getJarResources();
            Iterator jarResourceItr = jnlpJarResources.iterator();
            while (jarResourceItr.hasNext()) {
                JarResource jarResource = (JarResource)jarResourceItr.next();
                if (!this.commonJarResources.contains(jarResource)) continue;
                String message = "Configuration Error: The jar resource element for artifact " + jarResource + " defined in common jar resources is duplicated in the jar " + "resources configuration of the jnlp file identified by the template file " + jnlpFile.getTemplateFilename() + ".";
                throw new MojoExecutionException(message);
            }
        }
    }

    private void checkCommonJarResources() throws MojoExecutionException {
        if (this.commonJarResources == null) {
            return;
        }
        Iterator itr = this.commonJarResources.iterator();
        while (itr.hasNext()) {
            JarResource jarResource = (JarResource)itr.next();
            this.checkMandatoryJarResourceFields(jarResource);
            if (jarResource.getMainClass() == null) continue;
            throw new MojoExecutionException("Configuration Error: A mainClass must not be specified on a JarResource in the commonJarResources collection.");
        }
    }

    private void checkMandatoryJarResourceFields(JarResource jarResource) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)jarResource.getGroupId()) || StringUtils.isEmpty((String)jarResource.getArtifactId()) || StringUtils.isEmpty((String)jarResource.getVersion())) {
            throw new MojoExecutionException("Configuration error: groupId, artifactId or version missing for jarResource[" + jarResource + "].");
        }
    }

    private void checkForUniqueJnlpFilenames() throws MojoExecutionException {
        HashSet<String> filenames = new HashSet<String>(this.jnlpFiles.size());
        Iterator itr = this.jnlpFiles.iterator();
        while (itr.hasNext()) {
            JnlpFile jnlpFile = (JnlpFile)itr.next();
            if (filenames.add(jnlpFile.getOutputFilename())) continue;
            throw new MojoExecutionException("Configuration error: Unique JNLP filenames must be provided. The following file name appears more than once [" + jnlpFile.getOutputFilename() + "].");
        }
    }

    private void retrieveJarResources(List jarResources) throws MojoExecutionException {
        HashSet<Artifact> jarResourceArtifacts = new HashSet<Artifact>();
        try {
            Artifact artifact;
            JarResource jarResource;
            Iterator itr = jarResources.iterator();
            while (itr.hasNext()) {
                jarResource = (JarResource)itr.next();
                artifact = this.createArtifact(jarResource);
                this.getArtifactResolver().resolve(artifact, this.getRemoteRepositories(), this.getLocalRepository());
                jarResource.setArtifact(artifact);
                this.checkForMainClass(jarResource);
                jarResourceArtifacts.add(artifact);
            }
            if (!this.isExcludeTransitive()) {
                this.retrieveTransitiveDependencies(jarResourceArtifacts, jarResources);
            }
            itr = jarResources.iterator();
            while (itr.hasNext()) {
                jarResource = (JarResource)itr.next();
                artifact = jarResource.getArtifact();
                boolean copied = this.copyJarAsUnprocessedToDirectoryIfNecessary(artifact.getFile(), this.getLibDirectory());
                if (copied) {
                    String name = artifact.getFile().getName();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Adding " + name + " to modifiedJnlpArtifacts list."));
                    }
                    this.getModifiedJnlpArtifacts().add(name.substring(0, name.lastIndexOf(46)));
                }
                if (!jarResource.isOutputJarVersion()) continue;
                String hrefValue = this.buildHrefValue(artifact);
                jarResource.setHrefValue(hrefValue);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve an artifact", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find an artifact", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy an artifact to the working directory", (Exception)e);
        }
    }

    private Artifact createArtifact(JarResource jarResource) {
        if (jarResource.getClassifier() == null) {
            return this.getArtifactFactory().createArtifact(jarResource.getGroupId(), jarResource.getArtifactId(), jarResource.getVersion(), "runtime", "jar");
        }
        return this.getArtifactFactory().createArtifactWithClassifier(jarResource.getGroupId(), jarResource.getArtifactId(), jarResource.getVersion(), "jar", jarResource.getClassifier());
    }

    private void checkForMainClass(JarResource jarResource) throws MojoExecutionException {
        String mainClass = jarResource.getMainClass();
        if (mainClass == null) {
            return;
        }
        Artifact artifact = jarResource.getArtifact();
        if (artifact == null) {
            throw new IllegalStateException("Implementation Error: The given jarResource cannot be checked for a main class until the underlying artifact has been resolved: [" + jarResource + "]");
        }
        try {
            if (!this.artifactContainsClass(artifact, mainClass)) {
                throw new MojoExecutionException("The jar specified by the following jarResource does not contain the declared main class:" + jarResource);
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Attempting to find main class [" + mainClass + "] in [" + artifact + "]", (Exception)e);
        }
    }

    private void retrieveTransitiveDependencies(Set jarResourceArtifacts, List jarResources) throws ArtifactResolutionException, ArtifactNotFoundException {
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("runtime");
        ArtifactResolutionResult result = this.getArtifactResolver().resolveTransitively(jarResourceArtifacts, this.getProject().getArtifact(), null, this.getLocalRepository(), this.getRemoteRepositories(), this.artifactMetadataSource, (ArtifactFilter)artifactFilter);
        Set transitiveResolvedArtifacts = result.getArtifacts();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("transitively resolved artifacts = " + transitiveResolvedArtifacts));
            this.getLog().debug((CharSequence)("jarResources = " + jarResources));
            this.getLog().debug((CharSequence)("jarResourceArtifacts = " + jarResourceArtifacts));
        }
        Iterator itr = transitiveResolvedArtifacts.iterator();
        while (itr.hasNext()) {
            JarResource newJarResource;
            Artifact resolvedArtifact = (Artifact)itr.next();
            if (jarResourceArtifacts.contains(resolvedArtifact) || jarResources.contains(newJarResource = new JarResource(resolvedArtifact)) || newJarResource.getType().equals("pom")) continue;
            newJarResource.setOutputJarVersion(true);
            jarResources.add(newJarResource);
        }
    }

    private void generateJnlpFile(JnlpFile jnlpFile, String libPath) throws MojoExecutionException {
        File jnlpOutputFile = new File(this.getWorkDirectory(), jnlpFile.getOutputFilename());
        LinkedHashSet<JarResource> jarResources = new LinkedHashSet<JarResource>();
        jarResources.addAll(jnlpFile.getJarResources());
        if (this.commonJarResources != null && !this.commonJarResources.isEmpty()) {
            Iterator itr = this.commonJarResources.iterator();
            while (itr.hasNext()) {
                JarResource jarResource = (JarResource)itr.next();
                jarResources.add(jarResource);
            }
            jarResources.addAll(this.commonJarResources);
        }
        JarResourcesGenerator jnlpGenerator = new JarResourcesGenerator(this.getProject(), this.getTemplateDirectory(), "default-jnlp-servlet-template.vm", jnlpOutputFile, jnlpFile.getTemplateFilename(), jarResources, jnlpFile.getMainClass(), this.getWebstartJarURLForVelocity(), libPath);
        jnlpGenerator.setExtraConfig(this.getGeneratorExtraConfig());
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("The following error occurred attempting to generate the JNLP deployment descriptor: " + e, e);
        }
    }

    private GeneratorExtraConfig getGeneratorExtraConfig() {
        return new GeneratorExtraConfig(){

            public String getJnlpSpec() {
                return "1.0+";
            }

            public String getOfflineAllowed() {
                return "false";
            }

            public String getAllPermissions() {
                return "true";
            }

            public String getJ2seVersion() {
                return "1.5+";
            }

            public String getJnlpCodeBase() {
                return JnlpDownloadServletMojo.this.getCodebase();
            }
        };
    }

    private void generateVersionXml() throws MojoExecutionException {
        LinkedHashSet jarResources = new LinkedHashSet();
        Iterator itr = this.jnlpFiles.iterator();
        while (itr.hasNext()) {
            JnlpFile jnlpFile = (JnlpFile)itr.next();
            jarResources.addAll(jnlpFile.getJarResources());
        }
        if (this.commonJarResources != null) {
            jarResources.addAll(this.commonJarResources);
        }
        VersionXmlGenerator generator = new VersionXmlGenerator();
        generator.generate(this.getLibDirectory(), jarResources);
    }

    public MavenProject getProject() {
        return this.project;
    }

    private String buildHrefValue(Artifact artifact) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(artifact.getArtifactId());
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            sbuf.append("-").append(artifact.getClassifier());
        }
        sbuf.append(".").append(artifact.getArtifactHandler().getExtension());
        return sbuf.toString();
    }

    private void copyWorkingDirToOutputDir() throws MojoExecutionException {
        File outputDir = new File(this.getProject().getBuild().getDirectory(), this.getProject().getBuild().getFinalName() + File.separator + this.outputDirectoryName);
        if (!outputDir.exists()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Creating JNLP output directory: " + outputDir.getAbsolutePath()));
            }
            if (!outputDir.mkdirs()) {
                throw new MojoExecutionException("Unable to create the output directory for the jnlp bundle");
            }
        }
        try {
            FileUtils.copyDirectoryStructure((File)this.getWorkDirectory(), (File)outputDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred attempting to copy a file to the JNLP output directory.", (Exception)e);
        }
    }
}

