/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public class Bootstrapper {
    private static final Pattern WINDOWS_SPECIAL_CHAR = Pattern.compile("[\\ \\&\\(\\)\\[\\]\\{\\}\\^\\=\\;\\!\\'\\+\\,\\`\\~]");
    private static boolean DELETE_JAR = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(String classPath, String[] args) throws IOException, InterruptedException, URISyntaxException {
        File classPathJar = null;
        try {
            Runtime rt = Runtime.getRuntime();
            String osName = System.getProperty("os.name");
            ArrayList<String> cmd = new ArrayList<String>();
            if (osName.equals("Windows NT")) {
                cmd.add("cmd.exe");
                cmd.add("/C");
            }
            cmd.add(System.getProperty("java.home") + "/bin/java");
            String myClassPath = Bootstrapper.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            StringBuilder sb = new StringBuilder(myClassPath).append(' ').append(classPath);
            classPathJar = Bootstrapper.buildClasspathJar(sb.toString(), Bootstrapper.class.getName());
            cmd.add("-jar");
            cmd.add(classPathJar.getPath());
            for (String arg : args) {
                if ("Windows NT".equals(osName)) {
                    Matcher matcher = WINDOWS_SPECIAL_CHAR.matcher(arg);
                    if (matcher.find()) {
                        cmd.add("\"" + arg + "\"");
                        continue;
                    }
                    cmd.add(arg);
                    continue;
                }
                cmd.add(arg);
            }
            System.out.println(cmd);
            Process proc = rt.exec(cmd.toArray(new String[cmd.size()]));
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "[ERROR]");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "[INFO]");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            System.out.println("result: " + exitVal);
            if (exitVal != 0) {
                throw new RuntimeException(String.format("Bootstrapper returned %d exit code!", exitVal));
            }
        }
        finally {
            if (classPathJar != null && DELETE_JAR) {
                classPathJar.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File buildClasspathJar(String classPath, String mainClass) throws IOException {
        File file = null;
        ZipOutputStream jarOut = null;
        try {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Create-Date", new Date().toString());
            attributes.put(Attributes.Name.CLASS_PATH, classPath);
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, "JWSC Classpath Jar");
            attributes.put(Attributes.Name.MAIN_CLASS, mainClass);
            file = File.createTempFile("weblogicMojoBooter", ".jar");
            jarOut = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
            jarOut.flush();
        }
        finally {
            if (jarOut != null) {
                try {
                    jarOut.close();
                }
                catch (IOException e) {}
            }
        }
        return file;
    }

    public static void main(String[] args) throws Exception {
        String pathSeparator = System.getProperty("path.separator");
        if (pathSeparator == null) {
            throw new IllegalArgumentException("System Property 'path.separator' was not supplied and is required.");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("Must specify at least the class name to load from the classloader.");
        }
        String executableClassName = args[0];
        Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass(executableClassName);
        Method main = mainClass.getMethod("main", args.getClass());
        if (main == null) {
            throw new IllegalArgumentException("Must specific main method in class " + executableClassName);
        }
        if (args.length > 1) {
            String[] nextArgs = new String[args.length - 1];
            System.arraycopy(args, 1, nextArgs, 0, nextArgs.length);
            main.invoke(null, new Object[]{nextArgs});
        } else {
            main.invoke(null, new Object[0]);
        }
    }

    private static File getFile(String descriptor) {
        File file;
        try {
            file = new File(new URI(descriptor));
        }
        catch (Exception e) {
            file = new File(descriptor);
        }
        return file;
    }

    static class StreamGobbler
    extends Thread {
        private InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
            this.setDaemon(true);
            this.setName(type);
        }

        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

