/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.Service;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.ant.taskdefs.webservices.servicegen.ServiceGenTask;

public class ServiceGenMojo
extends AbstractWeblogicMojo {
    private String inputArtifactPath;
    private String outputDir;
    private String packageName;
    private Service[] services;
    private String contextUri;
    private String warName;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic service gen beginning ");
        }
        this.inputArtifactPath = WeblogicMojoUtilities.updateArtifactName(this.inputArtifactPath, "ear");
        try {
            Project project = new Project();
            project.setName("servicegen");
            Path path = new Path(project, WeblogicMojoUtilities.getDependencies(this.getArtifacts()));
            ServiceGenTask servicegen = new ServiceGenTask();
            this.addToolsJar(ClassLoader.getSystemClassLoader());
            servicegen.setProject(project);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Weblogic service gen using classpath: " + path));
            }
            servicegen.setClasspath(path);
            servicegen.setWarName(this.warName);
            servicegen.setContextURI(this.contextUri);
            File source = new File(this.inputArtifactPath);
            servicegen.setDestear(source);
            servicegen.setKeepGenerated(true);
            for (int i = 0; i < this.services.length; ++i) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Configuring service " + this.services[i].getServiceName()));
                }
                weblogic.ant.taskdefs.webservices.servicegen.Service service = servicegen.createService();
                service.setIncludeEjbs(this.services[i].getIncludeEJBs());
                service.setServiceName(this.services[i].getServiceName());
                service.setServiceURI(this.services[i].getServiceUri());
                service.setTargetNamespace(this.services[i].getTargetNamespace());
                service.setGenerateTypes(this.services[i].isGenerateTypes());
                service.setExpandMethods(this.services[i].isExpandMethods());
                service.setEjbJar(WeblogicMojoUtilities.getEjbJarFileName(this.getArtifacts()));
            }
            servicegen.execute();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during service gen ", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during listapps", ex);
        }
        finally {
            WeblogicMojoUtilities.unsetWeblogicProtocolHandler();
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic service gen successful ");
        }
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String inOutputDir) {
        this.outputDir = inOutputDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public Service[] getServices() {
        return this.services;
    }

    public void setServices(Service[] services) {
        this.services = services;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ServiceGenMojo[");
        buffer.append("warName = ").append(this.warName);
        buffer.append(", outputDir = ").append(this.outputDir);
        buffer.append(", packageName = ").append(this.packageName);
        buffer.append("]");
        return buffer.toString();
    }

    public String getWarName() {
        return this.warName;
    }

    public String getInputArtifactPath() {
        return this.inputArtifactPath;
    }

    public void setInputArtifactPath(String inputArtifactPath) {
        this.inputArtifactPath = inputArtifactPath;
    }

    public void setWarName(String warName) {
        this.warName = warName;
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public void setContextUri(String contextUri) {
        this.contextUri = contextUri;
    }
}

