/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.ReportRenderer;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.VersionsReportRendererBase;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractVersionsReportRenderer<T>
extends VersionsReportRendererBase
implements ReportRenderer {
    protected T model;
    protected ArtifactVersionsCache newestUpdateCache = new ArtifactVersionsCache(AbstractVersionDetails::getNewestUpdate);
    protected ArtifactVersionsCache allUpdatesCache = new ArtifactVersionsCache(AbstractVersionDetails::getAllUpdates);

    protected AbstractVersionsReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, T model) {
        super(sink, i18n, locale, bundleName);
        this.model = model;
    }

    protected void renderBody() {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.renderOverview();
        this.renderManagementSummaryTable();
        this.renderSummaryTable();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.detail.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text"));
        this.sink.paragraph_();
        this.renderDetails();
        this.sink.section1_();
    }

    protected void renderOverview() {
        this.sink.table();
        this.sink.tableRow();
        this.renderOverviewTableRow(this.computeOverviewStats());
        this.sink.tableRow_();
        this.sink.table_();
    }

    protected abstract void renderManagementSummaryTable();

    protected abstract void renderSummaryTable();

    protected <Q extends OverviewStats> void renderOverviewTableRow(Q stats) {
        this.renderStatRow("report.overview.numUpToDate", stats.getUpToDate(), true);
        this.renderStatRow("report.overview.numNewerVersionAvailable", stats.getAny(), false);
        this.renderStatRow("report.overview.numNewerIncrementalAvailable", stats.getIncremental(), false);
        this.renderStatRow("report.overview.numNewerMinorAvailable", stats.getMinor(), false);
        this.renderStatRow("report.overview.numNewerMajorAvailable", stats.getMajor(), false);
    }

    protected void renderStatRow(String textKey, int statCount, boolean forceSuccessIcon) {
        this.sink.tableRow();
        this.sink.tableCell();
        if (statCount == 0 || forceSuccessIcon) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText(textKey));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(statCount));
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected abstract <Q extends OverviewStats> Q computeOverviewStats();

    protected abstract void renderDetails();

    protected void renderSummaryTable(Map<Dependency, ArtifactVersions> contents, boolean hasScope) {
        this.sink.table();
        this.sink.tableRow();
        this.renderSummaryTableHeader(hasScope, true);
        this.sink.tableRow_();
        contents.forEach((artifact, artifactVersions) -> this.renderSummaryTableRow((Dependency)artifact, (ArtifactVersions)artifactVersions, hasScope));
        this.sink.tableRow();
        this.renderSummaryTableHeader(hasScope, true);
        this.sink.tableRow_();
        this.sink.table_();
    }

    protected void renderSummaryTableHeader(boolean hasScope, boolean hasType) {
        this.renderTableHeaderCells("report.status", "report.groupId", "report.artifactId", "report.currentVersion");
        if (hasScope) {
            this.renderTableHeaderCells("report.scope");
        }
        if (hasType) {
            this.renderTableHeaderCells("report.classifier", "report.type");
        }
        this.renderTableHeaderCells("report.latestSubIncremental", "report.latestIncremental", "report.latestMinor", "report.latestMajor");
    }

    protected void renderSummaryTableRow(Dependency artifact, ArtifactVersions details, boolean includeScope) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get(details, Optional.empty());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.sink.tableRow();
        this.sink.tableCell();
        if (upToDate) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getGroupId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getVersion());
        this.sink.tableCell_();
        if (includeScope) {
            this.sink.tableCell();
            this.sink.text(artifact.getScope());
            this.sink.tableCell_();
        }
        this.sink.tableCell();
        this.sink.text(artifact.getClassifier());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getType());
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderDependencyDetailTable(Dependency artifact, ArtifactVersions details, boolean includeScope) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get(details, Optional.empty());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        SinkEventAttributeSet headerAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"70%");
        SinkEventAttributeSet cellAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"30%");
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.groupId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(artifact.getGroupId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.artifactId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(artifact.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(artifact.getVersion());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (includeScope) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.scope"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            this.sink.text(artifact.getScope());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.classifier"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(artifact.getClassifier());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.type"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(artifact.getType());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (!upToDate) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.updateVersions"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            for (int i = 0; i < allUpdates.length; ++i) {
                String label;
                if (i > 0) {
                    this.sink.lineBreak();
                }
                if ((label = this.getLabel(allUpdates[i], details)) != null) {
                    this.safeBold();
                }
                this.sink.text(allUpdates[i].toString());
                if (label == null) continue;
                this.safeBold_();
                this.sink.nonBreakingSpace();
                this.safeItalic();
                this.sink.text(label);
                this.safeItalic_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected void renderTableHeaderCells(String ... keys) {
        Arrays.stream(keys).map(this::getText).forEachOrdered(str -> {
            this.sink.tableHeaderCell();
            this.sink.text(str);
            this.sink.tableHeaderCell_();
        });
    }

    protected String getLabel(ArtifactVersion version, AbstractVersionDetails details) {
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)))) {
            return this.getText("report.latestSubIncremental");
        }
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)))) {
            return this.getText("report.latestIncremental");
        }
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)))) {
            return this.getText("report.latestMinor");
        }
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)))) {
            return this.getText("report.latestMajor");
        }
        return null;
    }
}

