/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.versions.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.utils.PropertyComparator;
import org.codehaus.plexus.i18n.I18N;

public class PropertyUpdatesRenderer
extends AbstractVersionsReportRenderer {
    private final Map propertyUpdates;

    public PropertyUpdatesRenderer(Sink sink, I18N i18n, String bundleName, Locale locale, Map propertyUpdates) {
        super(sink, bundleName, i18n, locale);
        this.propertyUpdates = propertyUpdates;
    }

    protected void renderBody() {
        TreeMap allUpdates = new TreeMap(new PropertyComparator());
        allUpdates.putAll(this.propertyUpdates);
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.renderSummaryTotalsTable(allUpdates);
        this.renderSummaryTable("report.overview.property", this.propertyUpdates, "report.overview.noProperty");
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.detail.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text"));
        this.sink.paragraph_();
        Iterator it = allUpdates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.renderPropertyDetail((Property)entry.getKey(), (PropertyVersions)entry.getValue());
        }
        this.sink.section1_();
    }

    private void renderSummaryTable(String titleKey, Map contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.renderPropertySummaryTable(contents);
        }
        this.sink.section2_();
    }

    private void renderSummaryTotalsTable(Map allUpdates) {
        int numInc = 0;
        int numMin = 0;
        int numMaj = 0;
        int numAny = 0;
        int numCur = 0;
        Iterator iterator = allUpdates.values().iterator();
        while (iterator.hasNext()) {
            PropertyVersions details = (PropertyVersions)iterator.next();
            if (details.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
                ++numAny;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
                ++numInc;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.MINOR) != null) {
                ++numMin;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.MAJOR) != null) {
                ++numMaj;
                continue;
            }
            ++numCur;
        }
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderSuccessIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numUpToDate"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numCur));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerVersionAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numAny));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerIncrementalAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numInc));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerMinorAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numMin));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerMajorAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numMaj));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
    }

    private void renderPropertyDetail(Property property, PropertyVersions versions) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text("${" + property.getName() + "}");
        this.sink.sectionTitle2_();
        this.renderPropertyDetailTable(property, versions);
        this.sink.section2_();
    }
}

