/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class CompareDependenciesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final int INFO_PAD_SIZE = 68;
    protected String remotePom;
    protected boolean ignoreRemoteDependencies;
    protected boolean ignoreRemoteDependencyManagement;
    protected boolean updateDependencies;
    protected boolean updatePropertyVersions;
    protected boolean reportMode;
    protected File reportOutputFile;
    protected MavenProjectBuilder mavenProjectBuilder;

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        String[] remotePomParts;
        if (this.ignoreRemoteDependencies && this.ignoreRemoteDependencyManagement) {
            throw new MojoFailureException(" ignoreRemoteDependencies and ignoreRemoteDependencyManagementare both set to true.  At least one of these needs to be false ");
        }
        if (this.updateDependencies) {
            this.reportMode = false;
        }
        if ((remotePomParts = this.remotePom.split(":")).length != 3) {
            throw new MojoFailureException(" Invalid format for remotePom: " + this.remotePom);
        }
        String rGroupId = remotePomParts[0];
        String rArtifactId = remotePomParts[1];
        String rVersion = remotePomParts[2];
        Dependency remoteDependency = new Dependency();
        remoteDependency.setGroupId(rGroupId);
        remoteDependency.setArtifactId(rArtifactId);
        remoteDependency.setVersion(rVersion);
        Artifact remoteArtifact = this.toArtifact(remoteDependency);
        MavenProject remoteMavenProject = null;
        try {
            remoteMavenProject = this.mavenProjectBuilder.buildFromRepository(remoteArtifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Unable to build remote project " + remoteArtifact, (Exception)((Object)e));
        }
        HashMap remoteDepsMap = new HashMap();
        if (!this.ignoreRemoteDependencyManagement) {
            List remoteProjectDepMgmtDeps = remoteMavenProject.getDependencyManagement().getDependencies();
            this.mapDependencies(remoteDepsMap, remoteProjectDepMgmtDeps);
        }
        if (!this.ignoreRemoteDependencies) {
            List remoteProjectDeps = remoteMavenProject.getDependencies();
            this.mapDependencies(remoteDepsMap, remoteProjectDeps);
        }
        ArrayList totalDiffs = new ArrayList();
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            List depManDiffs = this.compareVersions(pom, this.getProject().getDependencyManagement().getDependencies(), remoteDepsMap);
            totalDiffs.addAll(depManDiffs);
        }
        if (this.isProcessingDependencies()) {
            List depDiffs = this.compareVersions(pom, this.getProject().getDependencies(), remoteDepsMap);
            totalDiffs.addAll(depDiffs);
        }
        if (this.reportMode) {
            this.getLog().info((CharSequence)"The following differences were found:");
            Iterator iter = totalDiffs.iterator();
            while (iter.hasNext()) {
                this.getLog().info((CharSequence)("  " + iter.next()));
            }
        }
        if (this.reportOutputFile != null) {
            this.writeReportFile(totalDiffs);
        }
    }

    private List compareVersions(ModifiedPomXMLEventReader pom, List dependencies, Map remoteDependencies) throws MojoExecutionException, XMLStreamException {
        ArrayList<String> updates = new ArrayList<String>();
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            Dependency remoteDep;
            Dependency dep = (Dependency)iter.next();
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact) || (remoteDep = (Dependency)remoteDependencies.get(dep.getManagementKey())) == null) continue;
            String remoteVersion = remoteDep.getVersion();
            if (dep.getVersion().equals(remoteVersion)) continue;
            StringBuffer buf = this.writeDependencyDiffMessage(dep, remoteVersion);
            updates.add(buf.toString());
            if (this.reportMode || !PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), remoteVersion)) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + remoteVersion));
        }
        return updates;
    }

    private void writeReportFile(List updates) throws MojoExecutionException {
        if (!this.reportOutputFile.getParentFile().exists()) {
            this.reportOutputFile.getParentFile().mkdirs();
        }
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(this.reportOutputFile);
            pw = new PrintWriter(fw);
            Iterator iter = updates.iterator();
            pw.println("The following differences were found:");
            pw.println();
            while (iter.hasNext()) {
                pw.println("  " + iter.next());
            }
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write report file. ", (Exception)e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException io) {}
            }
        }
    }

    private StringBuffer writeDependencyDiffMessage(Dependency dep, String remoteVersion) {
        StringBuffer buf = new StringBuffer();
        buf.append(dep.getGroupId()).append(':');
        buf.append(dep.getArtifactId());
        buf.append(' ');
        int padding = 68 - dep.getVersion().length() - remoteVersion.length() - 4;
        while (buf.length() < padding) {
            buf.append('.');
        }
        buf.append(' ');
        buf.append(dep.getVersion());
        buf.append(" -> ");
        buf.append(remoteVersion);
        return buf;
    }

    private void mapDependencies(Map map, List deps) {
        Iterator iter = deps.iterator();
        while (iter.hasNext()) {
            Dependency nextDep = (Dependency)iter.next();
            map.put(nextDep.getManagementKey(), nextDep);
        }
    }
}

