/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.solaris;

import org.codehaus.mojo.solaris.AbstractPrototypeEntry;
import org.codehaus.mojo.solaris.Defaults;

public abstract class SinglePrototypeEntry
extends AbstractPrototypeEntry {
    private String path;
    private String realPath;
    private boolean requiresSlashPrefixOnPaths;

    protected SinglePrototypeEntry(boolean requiresSlashPrefixOnPaths) {
        this.requiresSlashPrefixOnPaths = requiresSlashPrefixOnPaths;
    }

    protected SinglePrototypeEntry(boolean requiresSlashPrefixOnPaths, String pkgClass, String mode, String user, String group, String path, String realPath) {
        super(pkgClass, mode, user, group);
        this.requiresSlashPrefixOnPaths = requiresSlashPrefixOnPaths;
        this.path = path;
        this.realPath = realPath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRealPath() {
        return this.realPath;
    }

    public void setRealPath(String realPath) {
        this.realPath = realPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || SinglePrototypeEntry.class != o.getClass()) {
            return false;
        }
        SinglePrototypeEntry that = (SinglePrototypeEntry)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "[" + this.getPrototypeLine() + "]";
    }

    protected String getProcessedPath() {
        if (this.realPath == null) {
            return this.getPath();
        }
        return this.getPath() + "=" + this.getRealPath();
    }

    public final String getPrototypeLine() {
        return this.generatePrototypeLine();
    }

    public void validate(Defaults defaults) {
        super.validate(defaults);
        if (this.path == null) {
            throw new RuntimeException("Missing path in directory entry.");
        }
        if (this.requiresSlashPrefixOnPaths && !this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
    }

    public abstract String generatePrototypeLine();
}

