/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.patch.PatchContext;
import org.codehaus.mojo.project.archive.AbstractProjectSourcesMojo;
import org.codehaus.mojo.project.archive.ProjectSourceContext;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.mojo.tools.fs.archive.ArchiveFileExtensions;
import org.codehaus.mojo.tools.fs.archive.ArchiverManagerUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;

public class PackageProjectSourcesMojo
extends AbstractProjectSourcesMojo {
    private String archiveFilePrefix;
    private List excludes;
    private List includes;
    private boolean includePatchDirectory;
    private File outputDirectory;
    private String tarLongFileMode;
    private ArchiverManager archiverManager;
    protected BuildAdvisor buildAdvisor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectSourceContext context;
        try {
            context = this.loadContext();
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to read build cookies.");
        }
        if (!context.isSourceArtifactResolved()) {
            Artifact sourceArtifact;
            File originalLocation = context.getOriginalProjectSourceLocation();
            if (originalLocation == null) {
                throw new MojoExecutionException("Original project-sources location not found. \nPlease ensure that the resolve-project-sources mojo is bound to the current lifecycle.");
            }
            if (originalLocation.isDirectory()) {
                sourceArtifact = this.createArchive(originalLocation);
            } else {
                String ext = ArchiveFileExtensions.getArchiveFileExtension((File)originalLocation);
                sourceArtifact = this.getProjectSourcesArtifact(ext);
                sourceArtifact.setFile(originalLocation);
            }
            context.setProjectSourceArtifact(sourceArtifact);
            try {
                this.storeContext(context);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Unable to write build cookies.");
            }
        }
    }

    private Artifact createArchive(File archiveBasedir) throws MojoExecutionException {
        String patchExclude;
        String assemblyBaseLocation = this.makeRelative(archiveBasedir);
        ArrayList<String> archiveExcludes = new ArrayList<String>();
        archiveExcludes.addAll(FileUtils.getDefaultExcludesAsList());
        archiveExcludes.add("target/**");
        if (!this.includePatchDirectory && (patchExclude = this.getPatchExclude(assemblyBaseLocation)) != null) {
            archiveExcludes.add(patchExclude);
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                archiveExcludes.add(exclude);
            }
        }
        ArrayList<String> archiveIncludes = new ArrayList<String>();
        if (this.includes != null) {
            for (String include : this.includes) {
                archiveIncludes.add(include);
            }
        }
        if (archiveIncludes.isEmpty()) {
            archiveIncludes.add("**/*");
        }
        String fileName = this.archiveFilePrefix + "-" + this.getSourceArtifactClassifier();
        File projectSourcesArchive = new File(this.outputDirectory, fileName + "." + this.getSourceArtifactType());
        try {
            Map<String, String> options = Collections.singletonMap("tarLongFileMode", this.tarLongFileMode);
            Archiver archiver = ArchiverManagerUtils.getArchiver((ArchiverManager)this.archiverManager, (String)this.getSourceArtifactType(), options);
            archiver.setDestFile(projectSourcesArchive);
            this.getLog().debug((CharSequence)("project-sources archive contents should include: \n" + archiveIncludes));
            this.getLog().debug((CharSequence)("project-sources archive contents should exclude: \n" + archiveExcludes));
            String[] includeArry = archiveIncludes.toArray(new String[archiveIncludes.size()]);
            String[] excludeArry = archiveExcludes.toArray(new String[archiveExcludes.size()]);
            archiver.addDirectory(archiveBasedir, includeArry, excludeArry);
            archiver.createArchive();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Failed to lookup archiver for type: " + this.getSourceArtifactType(), (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to create project-sources archive.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create project-sources archive.", (Exception)e);
        }
        Artifact sourceArtifact = this.getProjectSourcesArtifact();
        sourceArtifact.setFile(projectSourcesArchive);
        return sourceArtifact;
    }

    private String makeRelative(File originalLocation) {
        File basedir = this.getProject().getFile().getParentFile();
        String basedirPath = basedir.getAbsolutePath().replace('\\', '/');
        String origPath = originalLocation.getAbsolutePath().replace('\\', '/');
        if (origPath.startsWith(basedirPath)) {
            String result = origPath.substring(basedirPath.length());
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            return result;
        }
        return origPath;
    }

    private String getPatchExclude(String assemblyBaseLocation) {
        PatchContext patchContext = new PatchContext(this.getSession(), this.buildAdvisor);
        if (patchContext != null && !patchContext.isPatchArtifactResolved()) {
            String originalPath = assemblyBaseLocation;
            String patchDir = patchContext.getPatchDirectory().getAbsolutePath();
            patchDir.replace('\\', '/');
            String patchExcludeBase = patchContext.getPatchDirectory().getPath();
            if (patchDir.startsWith(originalPath) && (patchExcludeBase = patchDir.substring(originalPath.length())).startsWith("/")) {
                patchExcludeBase = patchExcludeBase.substring(1);
            }
            return patchExcludeBase + "/**";
        }
        return null;
    }
}

