/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static void tryClose(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void tryClose(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean createDirectoryIfNecessary(File dir) throws IOException {
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new IOException("Could not create directory " + dir);
            }
            return true;
        }
        return false;
    }

    public static boolean createNewFile(File file) throws IOException {
        FileUtil.createDirectoryIfNecessary(file.getParentFile());
        if (!file.exists()) {
            boolean b = file.createNewFile();
            if (!b) {
                throw new IOException("Could not create new file " + file);
            }
            return true;
        }
        return false;
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        boolean b = file.delete();
        if (!b) {
            throw new IOException("could not delete file " + file);
        }
    }

    public static void renameFile(File file, File destination) throws IOException {
        try {
            try {
                FileUtils.forceDelete((File)destination);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            FileUtils.moveFile((File)file, (File)destination);
        }
        catch (IOException ex) {
            throw new IOException(String.format("could not rename '%s' to '%s'", file, destination));
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        FileUtil.createDirectoryIfNecessary(target.getParentFile());
        org.codehaus.plexus.util.FileUtils.copyFile((File)source, (File)target);
    }

    public static File getFile(File base, String ... paths) {
        StringBuilder buffer = new StringBuilder();
        for (String path : paths) {
            buffer.append(File.separator).append(path);
        }
        return new File(base, buffer.substring(1));
    }

    public static File getBackupFile(File file) {
        return new File(file.getAbsolutePath() + "~");
    }

    public static void backupFile(File f) throws IOException {
        File dst = FileUtil.getBackupFile(f);
        FileUtil.copyFile(f, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(File file, String encoding) throws IOException {
        FileInputStream inf = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inf, encoding));
        try {
            String string = IOUtil.toString((Reader)in);
            return string;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String content, String encoding) throws IOException {
        FileUtil.createDirectoryIfNecessary(file.getParentFile());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        try {
            IOUtil.copy((String)content, (Writer)out);
        }
        finally {
            out.close();
        }
    }

    public static List<File> orderFiles(Collection<File> files) {
        ArrayList<File> result = new ArrayList<File>(files);
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        return result;
    }
}

