/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.license.AbstractLicenseReportMojo;
import org.codehaus.mojo.license.ThirdPartyReportRenderer;
import org.codehaus.mojo.license.api.DefaultThirdPartyDetails;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.MojoHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="third-party-report", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ThirdPartyReportMojo
extends AbstractLicenseReportMojo
implements MavenProjectDependenciesConfigurator {
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes", defaultValue="")
    private String includedScopes;
    @Parameter(property="license.excludedGroups", defaultValue="")
    private String excludedGroups;
    @Parameter(property="license.includedGroups", defaultValue="")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts", defaultValue="")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts", defaultValue="")
    private String includedArtifacts;
    @Parameter(property="license.includeTransitiveDependencies", defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    private boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    private File missingFile;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    private boolean useRepositoryMissingFiles;
    @Parameter
    private List<String> licenseMerges;
    @Parameter(property="license.skipThirdPartyReport", defaultValue="false")
    private boolean skipThirdPartyReport;

    public String getOutputName() {
        return "third-party-report";
    }

    @Override
    public boolean isSkip() {
        return this.skipThirdPartyReport;
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException, MojoExecutionException, MojoFailureException {
        Collection<ThirdPartyDetails> details;
        try {
            details = this.createThirdPartyDetails();
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ThirdPartyToolException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        ThirdPartyReportRenderer renderer = new ThirdPartyReportRenderer(sink, this.getI18n(), this.getOutputName(), locale, details);
        renderer.render();
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    private Collection<ThirdPartyDetails> createThirdPartyDetails() throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException {
        SortedMap<String, MavenProject> projectDependencies = this.getHelper().loadDependencies(this);
        LicenseMap licenseMap = this.getHelper().createLicenseMap(projectDependencies);
        SortedSet<MavenProject> dependenciesWithNoLicense = this.getHelper().getProjectsWithNoLicense(licenseMap);
        TreeSet<MavenProject> dependenciesWithPomLicense = new TreeSet<MavenProject>(MojoHelper.newMavenProjectComparator());
        dependenciesWithPomLicense.addAll(projectDependencies.values());
        if (CollectionUtils.isNotEmpty(dependenciesWithNoLicense)) {
            dependenciesWithPomLicense.removeAll(dependenciesWithNoLicense);
            if (this.useMissingFile) {
                this.getHelper().createUnsafeMapping(licenseMap, this.missingFile, this.useRepositoryMissingFiles, dependenciesWithNoLicense, projectDependencies);
            }
        }
        this.getHelper().mergeLicenses(this.licenseMerges, licenseMap);
        ArrayList<ThirdPartyDetails> details = new ArrayList<ThirdPartyDetails>();
        for (Map.Entry<MavenProject, String[]> entry : licenseMap.toDependencyMap().entrySet()) {
            MavenProject dependency = entry.getKey();
            String[] licenses = entry.getValue();
            DefaultThirdPartyDetails detail = new DefaultThirdPartyDetails(dependency);
            details.add(detail);
            if (dependenciesWithPomLicense.contains(dependency)) {
                detail.setPomLicenses(licenses);
                continue;
            }
            if (dependenciesWithNoLicense.contains(dependency)) continue;
            detail.setThirdPartyLicenses(licenses);
        }
        return details;
    }
}

