/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.latex;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LaTeXMojo
extends AbstractMojo {
    private File docsRoot;
    private String commonsDirName;
    private File buildDir;
    private File latexBuildDir;
    private String binariesPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File[] docDirs = this.getDocDirs();
            File[] buildDirs = this.prepareLaTeXBuildDirectories(docDirs);
            this.buildDocuments(buildDirs);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void buildDocuments(File[] buildDirs) throws IOException, MojoFailureException {
        for (File dir : buildDirs) {
            File texFile = new File(dir, dir.getName() + ".tex");
            File pdfFile = new File(dir, dir.getName() + ".pdf");
            File bibFile = new File(dir, dir.getName() + ".bib");
            if (this.requiresBuilding(dir, pdfFile)) {
                CommandLine pdfLaTeX = CommandLine.parse((String)this.executablePath("pdflatex")).addArgument("-shell-escape").addArgument("--halt-on-error").addArgument(texFile.getAbsolutePath());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("pdflatex: " + pdfLaTeX));
                }
                CommandLine bibTeX = CommandLine.parse((String)this.executablePath("bibtex")).addArgument(dir.getName());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("bibtex: " + bibTeX));
                }
                this.execute(pdfLaTeX, dir);
                if (bibFile.exists()) {
                    this.execute(bibTeX, dir);
                    this.execute(pdfLaTeX, dir);
                }
                this.execute(pdfLaTeX, dir);
                FileUtils.copyFile((File)pdfFile, (File)new File(this.buildDir, pdfFile.getName()));
                continue;
            }
            if (!this.getLog().isInfoEnabled()) continue;
            this.getLog().info((CharSequence)("Skipping: no LaTeX changes detected in " + dir.getCanonicalPath()));
        }
    }

    private boolean requiresBuilding(File dir, File pdfFile) {
        Collection texFiles = FileUtils.listFiles((File)dir, (String[])new String[]{".tex", ".bib"}, (boolean)true);
        if (pdfFile.exists()) {
            boolean upToDate = true;
            Iterator it = texFiles.iterator();
            while (it.hasNext() && upToDate) {
                if (!FileUtils.isFileNewer((File)((File)it.next()), (File)pdfFile)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String executablePath(String executable) {
        if (this.binariesPath == null) {
            return executable;
        }
        return this.binariesPath + File.separator + executable;
    }

    private void execute(CommandLine commandLine, File dir) throws IOException, MojoFailureException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(dir);
        if (executor.execute(commandLine) != 0) {
            throw new MojoFailureException("Error code returned for: " + commandLine.toString());
        }
    }

    private File[] prepareLaTeXBuildDirectories(File[] docDirs) throws IOException {
        File[] buildDirs = new File[docDirs.length];
        File commonsDir = new File(this.docsRoot, this.commonsDirName);
        for (int i = 0; i < docDirs.length; ++i) {
            File target;
            File dir = docDirs[i];
            buildDirs[i] = target = new File(this.latexBuildDir, docDirs[i].getName());
            FileUtils.copyDirectory((File)dir, (File)target);
            if (commonsDir.exists()) {
                FileUtils.copyDirectory((File)commonsDir, (File)target);
            }
            Iterator iterator = FileUtils.iterateFiles((File)target, (String[])new String[]{".svn"}, (boolean)true);
            while (iterator.hasNext()) {
                FileUtils.deleteDirectory((File)((File)iterator.next()));
            }
        }
        return buildDirs;
    }

    private File[] getDocDirs() {
        return this.docsRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals(LaTeXMojo.this.commonsDirName) && !pathname.isHidden();
            }
        });
    }
}

