/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class NcssViolationCheckMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File xmlOutputDirectory;
    private boolean failOnViolation;
    private String tempFileName;
    private int ccnLimit;
    private int ncssLimit;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.sourceDirectory == null || !this.sourceDirectory.exists()) {
            return;
        }
        HashSet<String> ccnViolation = new HashSet<String>();
        HashSet<String> ncssViolation = new HashSet<String>();
        List methodList = this.loadDocument().selectNodes("//javancss/functions/function");
        Iterator nodeIterator = methodList.iterator();
        while (nodeIterator.hasNext()) {
            int ncss;
            Node node = (Node)nodeIterator.next();
            int ccn = new Integer(node.valueOf("ccn"));
            if (ccn > this.ccnLimit) {
                ccnViolation.add(node.valueOf("name"));
            }
            if ((ncss = new Integer(node.valueOf("ncss")).intValue()) <= this.ncssLimit) continue;
            ncssViolation.add(node.valueOf("name"));
        }
        this.reportViolation("ccn", ccnViolation, this.ccnLimit);
        this.reportViolation("ncss", ncssViolation, this.ncssLimit);
    }

    private Document loadDocument() throws MojoFailureException {
        File ncssXmlFile = new File(this.xmlOutputDirectory, this.tempFileName);
        try {
            return new SAXReader().read(ncssXmlFile);
        }
        catch (DocumentException de) {
            throw new MojoFailureException("Can't read javancss xml output file : " + ncssXmlFile);
        }
    }

    private void reportViolation(String statName, Set violationSet, int limit) throws MojoFailureException {
        this.getLog().debug((CharSequence)(statName + " Violation = " + violationSet.size()));
        if (violationSet.size() > 0) {
            String violationString = "Your code has " + violationSet.size() + " method(s) with a " + statName + " greater than " + limit;
            this.getLog().warn((CharSequence)violationString);
            Iterator iterator = violationSet.iterator();
            while (iterator.hasNext()) {
                this.getLog().warn((CharSequence)("    " + (String)iterator.next()));
            }
            if (this.failOnViolation) {
                throw new MojoFailureException(violationString);
            }
        }
    }
}

