/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ideauidesigner;

import com.intellij.uiDesigner.ant.Javac2;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class Javac2Mojo
extends AbstractMojo {
    private MavenProject project;
    private File sourceDirectory;
    private File destDirectory;
    private boolean fork;
    private boolean failOnError;
    private boolean debug;
    private boolean verbose;

    public void execute() throws MojoExecutionException {
        if (!this.destDirectory.exists() && !this.destDirectory.mkdirs()) {
            this.getLog().warn((CharSequence)"the destination directory doesn't exists and couldn't be created. The goal with probably fail.");
        }
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new DebugAntBuildListener());
        Javac2 task = new Javac2();
        task.setProject(antProject);
        task.setDestdir(this.destDirectory);
        task.setFailonerror(this.failOnError);
        Path classpath = new Path(antProject);
        Set artifacts = this.project.getArtifacts();
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (!"jar".equals(artifact.getType())) continue;
            classpath.createPathElement().setLocation(artifact.getFile());
        }
        classpath.createPathElement().setLocation(this.destDirectory);
        this.getLog().debug((CharSequence)("created classpath:" + classpath));
        task.setClasspath(classpath);
        task.setFork(this.fork);
        task.setDebug(this.debug);
        task.setVerbose(this.verbose);
        task.setSrcdir(new Path(antProject, this.sourceDirectory.getAbsolutePath()));
        task.setIncludes("**/*.form");
        this.getLog().info((CharSequence)"Executing IDEA UI Designer task...");
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException("command execution failed", (Exception)((Object)e));
        }
    }

    private class DebugAntBuildListener
    implements BuildListener {
        private DebugAntBuildListener() {
        }

        public void buildStarted(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void buildFinished(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void targetStarted(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void targetFinished(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void taskStarted(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void taskFinished(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void messageLogged(BuildEvent buildEvent) {
            Javac2Mojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }
    }
}

