/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:fitnesse-maven-plugin:1.1-beta-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "FitNesse Maven Plugin", 0);
        this.append(sb, "The Codehaus is a collaborative environment for building open source projects with a strong emphasis on modern languages, focussed on quality components that meet real world needs.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "fitnesse".equals(this.goal)) {
            this.append(sb, "fitnesse:fitnesse", 0);
            this.append(sb, "Generates a FitNesse report from a FitNesse web server. The generated report is an external report generated FitNesse itself. If the project use Clover for code coverage and if FitNesse has clover dependency (ie use the ArtifactId-Version-clover.jar), the code executed during the FitNesse execution (phase integration-test) will be had to the unit-test code coverage. See the clover example.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fitnesseOutputDirectory", 2);
                this.append(sb, "The directory where the Fitnesse report has be generated. It must be defined when it's not the default value (${project.build.directory}/fitnesse. It's the case for exemple with the clover plugin (that use ${project.build.directory}/clover/fitnesse).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory where the Fitnesse report will be generated.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.reporting.outputDirectory}/fitnesse", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDir", 2);
                this.append(sb, "Working directory", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputDirectory", 2);
                this.append(sb, "Report output directory. It should be defined in the reporting section of the pom.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/generated-site/xdoc/fitnesse", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "fitnesse:help", 0);
            this.append(sb, "Display help information on fitnesse-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0fitnesse:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remotecall".equals(this.goal)) {
            this.append(sb, "fitnesse:remotecall", 0);
            this.append(sb, "This goal uses the fitnesse.runner.TestRunner class for getting result of a remote FitNesse web page execution. It's possible to define several pages and/or servers.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnesseHostName", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnessePage", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.page}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnessePort", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnesseSuiteFilter", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.suiteFilter}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat (Default: dd/MM/yyyy HH:mm)", 2);
                this.append(sb, "Date format for FitNesse page timestamp.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "Fail the build if fitnesse pages have error.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fitnesses", 2);
                this.append(sb, "This is the list of FitNesse server pages.\nA FitNesse tag is compose of the nested tags:\n<fitnesses>\n\u00a0<fitnesse>\n\u00a0\u00a0<pageName>This is the only required parameter, the name of the FitNesse page</pageName>\n\u00a0\u00a0<hostName>default is locahost</hostName>\n\u00a0\u00a0<port>: default is 80</port>\n\u00a0\u00a0<serverId>ServerId defined in your settings.xml, this allows to use credentials (basic athentification) for calling your FitNesse pages</serverId>\n\u00a0\u00a0<type>Override the default type of the page (Suite or Test)</type>\n\u00a0\u00a0<suiteFilter>Allow the use of Suite filtering ( TestSuites )</suiteFilter>\n\u00a0</fitnesse>\n...\n</fitnesses>:\n", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "fitnesse:run", 0);
            this.append(sb, "This goal uses the fitnesse.runner.TestRunner class for calling a remote FitNesse web page and executes the tests or suites locally into a forked JVM. It's possible to define several pages and/or servers.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classPathProvider (Default: fitnesse)", 2);
                this.append(sb, "This property defines how the plugin will create the classpath for running fixtures. It accepts a couple of value: 'fitnesse' (default) or 'maven'.\nWith 'fitnesse' mode, the classpath is downloaded from the FitNesse server page. Then classpath of the plugin is appended (for providing the good FitNesse implementation).\nWith 'maven' mode the classpath is only defined with the one of the project (POM).", 3);
                this.append(sb, "", 0);
                this.append(sb, "classPathSubstitutions", 2);
                this.append(sb, "List of Classpath substitution. Substitutions allow to change the FitNesse class path.\nIt should be usefull when the server classpath is in a Unix syntaxe, or when libs are not located in the same folder on the server and on the developer desktop.\nThe order of substitutions is guaranteed to be the same than the definition.\nThe substitutions use String replacements (not patterns). <classPathSubstitutions>\n\u00a0\u00a0<classPathSubstitution>\n\u00a0\u00a0\u00a0\u00a0<search>The key that will be replace</search>\n\u00a0\u00a0\u00a0\u00a0<replaceWith>The value that should use to replace the key</replaceWith>\n\u00a0\u00a0</classPathSubstitution>\n\u00a0\u00a0...\n</classPathSubstitutions>:\nThis parameter can only be use if param classPathProvider has fitnesse value.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnesseHostName", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnessePage", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.page}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnessePort", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cmdFitnesseSuiteFilter", 2);
                this.append(sb, "Similar to the fitnesse configuration, but this parameter allow to override all the fitnesse by passing this parameter in the command line. FitnesseAbstractMojo.fitnesses", 3);
                this.append(sb, "Expression: ${fitnesse.suiteFilter}", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyDependencies (Default: false)", 2);
                this.append(sb, "Use shorter classpath. On Windows, the Win32 api doesn't allow to create a process via CMD.EXE that contains more than 8192 chars. When fitnesse-maven-plugin calls the page, the classpath that refers to the maven repository may easilly contains more than 8192 chars. see article Activating this property ask the plugin to copy all the dependency in the target folder. This may create an overhead but decrease the classpath size. For exemple the string [E:/Maven/repository/org/springframework /spring-beans/1.2.8/spring-beans-1.2.8.jar] (81 chars) became [lib/spring-beans-1.2.8.jar] (26 chars). That doesn't solve the problems but allows to use bigger classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat (Default: dd/MM/yyyy HH:mm)", 2);
                this.append(sb, "Date format for FitNesse page timestamp.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Run FitnesseRunner with debug option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayOutput (Default: false)", 2);
                this.append(sb, "Redirect FitNesse output into Maven2 log.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "Fail the build if fitnesse pages have error.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fitnesseRunnerClass (Default: fitnesse.runner.TestRunner)", 2);
                this.append(sb, "Fitnesse runner class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fitnesses", 2);
                this.append(sb, "This is the list of FitNesse server pages.\nA FitNesse tag is compose of the nested tags:\n<fitnesses>\n\u00a0<fitnesse>\n\u00a0\u00a0<pageName>This is the only required parameter, the name of the FitNesse page</pageName>\n\u00a0\u00a0<hostName>default is locahost</hostName>\n\u00a0\u00a0<port>: default is 80</port>\n\u00a0\u00a0<serverId>ServerId defined in your settings.xml, this allows to use credentials (basic athentification) for calling your FitNesse pages</serverId>\n\u00a0\u00a0<type>Override the default type of the page (Suite or Test)</type>\n\u00a0\u00a0<suiteFilter>Allow the use of Suite filtering ( TestSuites )</suiteFilter>\n\u00a0</fitnesse>\n...\n</fitnesses>:\n", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateXml (Default: false)", 2);
                this.append(sb, "Generate Xml file with results. Needed for integrating with CruiseControl", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdk (Default: java)", 2);
                this.append(sb, "Java executable.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkOpts", 2);
                this.append(sb, "Jvm arguments.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

