/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.fitnesse.FileUtil;
import org.codehaus.mojo.fitnesse.Fitnesse;
import org.codehaus.mojo.fitnesse.FitnesseAbstractMojo;
import org.codehaus.mojo.fitnesse.FitnessePage;
import org.codehaus.mojo.fitnesse.FitnesseReportMojo;

public class FitnesseRemoteRunnerMojo
extends FitnesseAbstractMojo {
    public static final String FORMAT_INVALID = "You should define at least one format (html or xml) for the parameter 'format'";
    public static final String START_REPORT_TAG_KO = "document.getElementById(\"test-summary\").className = \"fail\"";
    public static final String START_REPORT_TAG_KO2 = "document.getElementById(\"test-summary\").className = \"error\"";
    public static final String START_REPORT_TAG_OK = "document.getElementById(\"test-summary\").className = \"pass\"";
    private String format;
    boolean xmlOutput;
    boolean htmlOutput = true;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.xmlOutput = format.contains("xml");
        this.htmlOutput = format.contains("html");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        new File(this.workingDir).mkdirs();
        this.checkConfiguration();
        if (this.htmlOutput) {
            try {
                FitnesseReportMojo.copyAllResources(new File(this.workingDir), this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MavenReportException e) {
                throw new MojoExecutionException("Unable to copy resources", e.getCause());
            }
        }
        this.getLog().info((CharSequence)("Found " + this.getFitnesseSize() + " Fitnesse configuration."));
        MojoFailureException tLastFailure = null;
        for (int i = 0; i < this.getFitnesseSize(); ++i) {
            try {
                if (this.htmlOutput) {
                    this.callFitnesseHtml(i);
                }
                if (!this.xmlOutput) continue;
                this.callFitnesseXml(i);
                continue;
            }
            catch (MojoFailureException e) {
                tLastFailure = e;
            }
        }
        if (tLastFailure != null) {
            throw tLastFailure;
        }
    }

    void checkConfiguration() throws MojoExecutionException {
        super.checkConfiguration();
        if (!this.xmlOutput && !this.htmlOutput) {
            String errorMessage = FORMAT_INVALID;
            this.getLog().error((CharSequence)errorMessage);
            throw new MojoExecutionException(errorMessage);
        }
    }

    void callFitnesseHtml(int pServerConfPosition) throws MojoFailureException, MojoExecutionException {
        File tOutput;
        Fitnesse tServer = this.getFitnesse(pServerConfPosition);
        File tResultFile = new File(this.getFinalFileName(tServer));
        if (tResultFile.exists()) {
            tResultFile.delete();
        }
        if ((tOutput = new File(this.getOutputFileName(tServer))).exists()) {
            tOutput.delete();
        }
        try {
            FileOutputStream tOutputStream = new FileOutputStream(tOutput);
            tResultFile.createNewFile();
            ByteArrayOutputStream tOut = new ByteArrayOutputStream();
            String tUrl = "http://" + tServer.getHostName() + ":" + tServer.getPort() + "/" + tServer.getPageName() + "?responder=" + tServer.getType();
            if (tServer.getSuiteFilter() != null && tServer.getSuiteFilter().length() > 0) {
                if ("suite".equals(tServer.getType())) {
                    tUrl = tUrl + "&testFilter=" + tServer.getType();
                } else {
                    this.getLog().error((CharSequence)"The FitNesse parameter testFilter is only supported with Suite page (not Test page), it has be ignored...");
                }
            }
            this.getRemoteResource(tUrl, tOut, tServer);
            String tOutAsString = tOut.toString();
            FitnessePage tFitnessePage = new FitnessePage(tOutAsString);
            this.transformHtml(new ByteArrayInputStream(tOut.toByteArray()), new FileWriter(tResultFile), this.getOutputUrl(tServer), tFitnessePage.getStatus());
            this.getRemoteResource("http://" + tServer.getHostName() + ":" + tServer.getPort() + "/ErrorLogs." + tServer.getPageName(), tOutputStream, tServer);
            this.transformOutputPage(new File(this.getOutputFileName(tServer)));
            this.checkFailureInHtml(tOutAsString, tResultFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create File [" + tResultFile.getAbsolutePath() + "].", (Exception)e);
        }
    }

    void callFitnesseXml(int pServerConfPosition) throws MojoFailureException, MojoExecutionException {
        Fitnesse tServer = this.getFitnesse(pServerConfPosition);
        File tResultFile = new File(this.getResultFileName(tServer, "", "xml"));
        if (tResultFile.exists()) {
            tResultFile.delete();
        }
        try {
            FileOutputStream tOutputStream = new FileOutputStream(tResultFile);
            this.getRemoteResource("http://" + tServer.getHostName() + ":" + tServer.getPort() + "/" + tServer.getPageName() + "?" + tServer.getType() + "&format=xml", tOutputStream, tServer);
            this.checkFailureInXml(tResultFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create File [" + tResultFile.getAbsolutePath() + "].", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transformOutputPage(File pFinalOutputName) throws IOException, MojoExecutionException {
        int tEndIndex;
        String tSrcAsString = FileUtil.getString(pFinalOutputName);
        tSrcAsString = tSrcAsString.replaceAll("/files/css/", "");
        tSrcAsString = tSrcAsString.replaceAll("fitnesse.css", "fitnesse_base.css");
        tSrcAsString = tSrcAsString.replaceAll("/files/javascript/", "");
        StringBuffer tFinal = new StringBuffer();
        int tStartIndex = tSrcAsString.indexOf("<div class=\"sidebar\">");
        if (tStartIndex != -1) {
            tEndIndex = tSrcAsString.indexOf("<div class=\"mainbar\">");
            tFinal.append(tSrcAsString.substring(0, tStartIndex));
            tFinal.append(tSrcAsString.substring(tEndIndex, tSrcAsString.length()));
            tSrcAsString = tFinal.toString();
        }
        if ((tStartIndex = tSrcAsString.indexOf("<div class=\"header\">")) != -1) {
            tFinal = new StringBuffer();
            tEndIndex = tSrcAsString.indexOf("</div>\r\n") + "</div>\r\n".length();
            tFinal.append(tSrcAsString.substring(0, tStartIndex));
            tFinal.append(tSrcAsString.substring(tEndIndex, tSrcAsString.length()));
            tSrcAsString = tFinal.toString();
        }
        if (!pFinalOutputName.delete()) {
            throw new MojoExecutionException("Unable to delete output file");
        }
        FileWriter tWriter = null;
        try {
            tWriter = new FileWriter(pFinalOutputName);
            tWriter.write(tSrcAsString);
        }
        finally {
            if (tWriter != null) {
                tWriter.close();
            }
        }
    }

    void checkFailureInHtml(String pFileContent, String pFileName) throws MojoFailureException, MojoExecutionException {
        if (this.isFailOnError()) {
            int tIndexOk = pFileContent.indexOf(START_REPORT_TAG_OK);
            int tIndexKo = pFileContent.indexOf(START_REPORT_TAG_KO);
            int tIndexKo2 = pFileContent.indexOf(START_REPORT_TAG_KO2);
            if (tIndexOk == -1) {
                if (tIndexKo == -1 && tIndexKo2 == -1) {
                    throw new MojoExecutionException("Unable to find failure result into FitNesse page, resultFile=[" + pFileName + "].");
                }
                throw new MojoFailureException("FitNesse page fail, resultFile=[" + pFileName + "].");
            }
            if (tIndexKo != -1 || tIndexKo2 != -1) {
                throw new MojoExecutionException("Find both success and fail result into FitNesse page , resultFile=[" + pFileName + "].");
            }
        }
    }

    void checkFailureInXml(File outputFile) throws MojoFailureException, MojoExecutionException, IOException {
        if (this.isFailOnError()) {
            String pFileContent = FileUtil.getString(outputFile);
            int tIndexFinalCount = pFileContent.indexOf("<finalCounts>");
            int tIndexRightStart = pFileContent.indexOf("<right>", tIndexFinalCount);
            int tIndexRightEnd = pFileContent.indexOf("</right>", tIndexFinalCount);
            String rightAsString = pFileContent.substring(tIndexRightStart + 7, tIndexRightEnd);
            int right = Integer.parseInt(rightAsString);
            int tIndexWrongStart = pFileContent.indexOf("<wrong>", tIndexFinalCount);
            int tIndexWrongEnd = pFileContent.indexOf("</wrong>", tIndexFinalCount);
            String wrongAsString = pFileContent.substring(tIndexWrongStart + 7, tIndexWrongEnd);
            int wrong = Integer.parseInt(wrongAsString);
            int tIndexExceptionsStart = pFileContent.indexOf("<exceptions>", tIndexFinalCount);
            int tIndexExceptionsEnd = pFileContent.indexOf("</exceptions>", tIndexFinalCount);
            String exceptionsAsString = pFileContent.substring(tIndexExceptionsStart + 12, tIndexExceptionsEnd);
            int exceptions = Integer.parseInt(exceptionsAsString);
            if (wrong > 0 || exceptions > 0) {
                if (right == 0) {
                    throw new MojoFailureException("FitNesse page fail, resultFile=[" + outputFile.getAbsolutePath() + "].");
                }
                throw new MojoExecutionException("Find both success and fail result into FitNesse page, resultFile=[" + outputFile.getAbsolutePath() + "].");
            }
        }
    }

    void getRemoteResource(String pUrl, OutputStream pOutStream, Fitnesse pServer) throws MojoExecutionException {
        try {
            GetMethod tMethod;
            int tStatusCode;
            HttpClient tClient = new HttpClient();
            this.getLog().info((CharSequence)("Request resources from [" + pUrl + "]"));
            if (pServer.getServerId() != null) {
                tClient.getParams().setAuthenticationPreemptive(true);
                UsernamePasswordCredentials defaultcreds = this.getCredential(pServer.getServerId());
                AuthScope tAuthScope = new AuthScope(pServer.getHostName(), pServer.getPort(), AuthScope.ANY_REALM);
                tClient.getState().setCredentials(tAuthScope, (Credentials)defaultcreds);
                this.getLog().info((CharSequence)"Use credential for remote connection");
            }
            if ((tStatusCode = tClient.executeMethod((HttpMethod)(tMethod = new GetMethod(pUrl)))) != 200) {
                throw new MojoExecutionException("Bad response code from resource [" + pUrl + "], return code=[" + tStatusCode + "]");
            }
            InputStream tResponseStream = tMethod.getResponseBodyAsStream();
            byte[] tbytes = new byte[512];
            int tReadBytes = tResponseStream.read(tbytes);
            while (tReadBytes >= 0) {
                pOutStream.write(tbytes, 0, tReadBytes);
                tReadBytes = tResponseStream.read(tbytes);
            }
            pOutStream.flush();
            tMethod.releaseConnection();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read FitNesse server response.", (Exception)e);
        }
        finally {
            try {
                pOutStream.close();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to close Stream.");
            }
        }
    }

    public void setWorkingDir(String pWorkingDir) {
        this.workingDir = pWorkingDir;
    }

    String getOutputFileName(Fitnesse pServer) {
        return this.getResultFileName(pServer, "_output", "html");
    }

    String getOutputUrl(Fitnesse pServer) {
        return "fitnesseResult_" + pServer.getHostName() + "_" + pServer.getPageName() + "_output.html";
    }
}

