/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dita;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.dita.AbstractDitaMojo;
import org.codehaus.mojo.dita.AntOutputConsumer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DitaRunMojo
extends AbstractDitaMojo {
    private static final String DITA_BUILD_DIR = "basedir";
    private static final String DITA_TMP_DIR = "dita.temp.dir";
    private static final String DITA_OUT_DIR = "output.dir";
    private static final String DITA_LOG_DIR = "args.log";
    private static final String DITA_MAP = "args.input";
    private static final String DITA_TRANSTYPE = "transtype";
    private boolean useDitaAnt;
    private File antHome;
    private String antArguments;
    private String antOpts;
    private boolean attach = false;
    private String attachClassifier;
    private String attachType;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipped");
            return;
        }
        this.initialize();
        Commandline cl = new Commandline();
        cl.setExecutable(this.getAntExecutable().getAbsolutePath());
        cl.setWorkingDirectory(this.project.getBasedir());
        this.setupClasspathEnv(cl);
        this.setupAntEnv(cl);
        this.setupAntArguments(cl);
        this.executeCommandline(cl);
        if (this.attach) {
            this.attachTheOuput();
        }
    }

    protected void setupDefaultAntDirectory(String antPropertyName, File defaultDirectory) {
        this.setupDefaultAntProperty(antPropertyName, defaultDirectory.getAbsolutePath());
    }

    protected void setupDefaultAntProperty(String antPropertyName, String value) {
        if (this.antProperties.get(antPropertyName) == null) {
            this.antProperties.put(antPropertyName, value);
        }
    }

    private void initialize() throws MojoExecutionException {
        this.setupDitaDirectory();
        this.setupAntDirectory();
        this.setupDefaultAntDirectory(DITA_BUILD_DIR, this.project.getBasedir());
        File ditaBuildDir = new File(this.project.getBuild().getDirectory(), "dita");
        this.setupDefaultAntDirectory(DITA_OUT_DIR, new File(ditaBuildDir, "out"));
        this.setupDefaultAntDirectory(DITA_TMP_DIR, new File(ditaBuildDir, "temp"));
        this.setupDefaultAntDirectory(DITA_LOG_DIR, new File(ditaBuildDir, "log"));
        File defaultDitaMapFile = new File(this.project.getBasedir(), "/src/main/dita/" + this.project.getArtifactId() + ".ditamap");
        this.setupDefaultAntProperty(DITA_MAP, defaultDitaMapFile.getAbsolutePath());
    }

    protected void setupAntDirectory() throws MojoExecutionException {
        if (this.antHome == null) {
            if (this.useDitaAnt) {
                this.antHome = new File(this.ditaDirectory, "tools/ant");
            } else {
                String antPath = System.getenv("ANT_HOME");
                if (antPath == null) {
                    throw new MojoExecutionException("env.ANT_HOME not found.");
                }
                this.antHome = new File(antPath);
            }
        }
        if (!this.antHome.isDirectory()) {
            throw new MojoExecutionException(this.getAntPath() + " ditaDirectory not found. ");
        }
    }

    private void setupAntEnv(Commandline cl) throws MojoExecutionException {
        cl.addEnvironment("ANT_HOME", this.getAntPath());
        if (this.antOpts != null) {
            cl.addEnvironment("ANT_OPTS", this.antOpts);
            this.getLog().debug((CharSequence)("ANT_OPT=" + this.antOpts));
        }
    }

    private void setupAntArguments(Commandline cl) throws MojoExecutionException {
        if (!StringUtils.isBlank((String)this.antArguments)) {
            cl.addArguments(StringUtils.split((String)this.antArguments));
        }
        cl.createArg().setValue("-f");
        cl.createArg().setValue(this.getDitaBuildXmlPath());
        cl.createArg().setValue("-propertyfile");
        cl.createArg().setValue(this.setupAntProperties());
    }

    private String setupAntProperties() throws MojoExecutionException {
        String string;
        Properties inputProperties = new Properties();
        for (String key : this.antProperties.keySet()) {
            String value = (String)this.antProperties.get(key);
            if (value == null) continue;
            inputProperties.put(key, value);
        }
        FileOutputStream os = null;
        try {
            File tmpFile = new File((String)this.antProperties.get(DITA_TMP_DIR), "properties.temp");
            tmpFile.getParentFile().mkdirs();
            os = new FileOutputStream(tmpFile);
            inputProperties.store(os, null);
            string = tmpFile.getCanonicalPath();
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)os);
        return string;
    }

    private String getDitaBuildXmlPath() throws MojoExecutionException {
        try {
            return new File(this.ditaDirectory, "build.xml").getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String getAntPath() throws MojoExecutionException {
        try {
            return this.antHome.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private File getAntExecutable() throws MojoExecutionException {
        String antFileName = "ant";
        if (Os.isFamily((String)"windows")) {
            antFileName = antFileName + ".bat";
        }
        return new File(this.getAntPath(), "bin/" + antFileName);
    }

    protected void executeCommandline(Commandline cl) throws MojoExecutionException {
        int ok;
        try {
            AntOutputConsumer stdout = new AntOutputConsumer();
            AntOutputConsumer stderr = new AntOutputConsumer();
            this.getLog().debug((CharSequence)cl.toString());
            ok = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            if (stdout.isFailure() || stderr.isFailure()) {
                throw new MojoExecutionException("BUILD FAILED");
            }
        }
        catch (CommandLineException ecx) {
            throw new MojoExecutionException("Error executing command line", (Exception)((Object)ecx));
        }
        if (ok != 0) {
            throw new MojoExecutionException("Error executing command line. Exit code:" + ok);
        }
    }

    private void attachTheOuput() throws MojoExecutionException {
        File outputDir = new File((String)this.antProperties.get(DITA_OUT_DIR));
        String transtype = (String)this.antProperties.get(DITA_TRANSTYPE);
        if ("pdf".equals(transtype) || "pdf2".equals(transtype) || "legacypdf".equals(transtype)) {
            this.attachSingleOutput(this.attachClassifier, "pdf", outputDir);
        } else if ("htmlhelp".equals(transtype)) {
            this.attachSingleOutput(this.attachClassifier, "chm", outputDir);
        } else {
            this.archiveAndAttachTheOutput(outputDir, this.attachClassifier, this.attachType);
        }
    }

    private void attachSingleOutput(String classifier, String type, File outputDir) throws MojoExecutionException {
        File ditamap = new File((String)this.antProperties.get(DITA_MAP));
        String[] tokens = StringUtils.split((String)ditamap.getName(), (String)".");
        String fileName = "";
        for (int i = 0; i < tokens.length - 1; ++i) {
            fileName = fileName + tokens[i] + ".";
        }
        fileName = fileName + type;
        File ditaOutputFile = new File(outputDir, fileName);
        this.isAttachYet(ditaOutputFile);
        this.attachArtifact(classifier, type, ditaOutputFile);
    }
}

