/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartDecorator;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.utils.ChartUtils;
import org.jfree.chart.ChartColor;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.CenterArrangement;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendGraphic;
import org.jfree.chart.title.LegendItemBlockContainer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.VerticalAlignment;

public class MarkerTimeChartDecorator
extends AbstractChartDecorator {
    public MarkerTimeChartDecorator(IChartRenderer chartToDecorate, List markersToPlot) {
        super(chartToDecorate, markersToPlot);
    }

    public void createChart() {
        XYPlot xyplot = (XYPlot)this.report.getPlot();
        if (this.results != null && !this.results.isEmpty()) {
            Iterator iter1 = this.results.iterator();
            ValueMarker valuemarker = null;
            BlockContainer blockcontainerLabel = new BlockContainer((Arrangement)new ColumnArrangement());
            int i = 0;
            while (iter1.hasNext()) {
                Object[] item = (Object[])iter1.next();
                Date date = (Date)item[1];
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                valuemarker = new ValueMarker((double)cal.getTimeInMillis(), ChartColor.createDefaultPaintArray()[i], (Stroke)new BasicStroke(2.0f));
                xyplot.addDomainMarker((Marker)valuemarker);
                LegendItem legendLabel = new LegendItem((String)item[0], null, null, null, (Shape)new Line2D.Double(-7.0, 0.0, 7.0, 0.0), valuemarker.getPaint(), valuemarker.getStroke(), valuemarker.getPaint());
                blockcontainerLabel.add(this.createLegendItemBlock(legendLabel, i));
                ++i;
            }
            this.createLegendBlock(blockcontainerLabel);
        }
    }

    public Color getBackgroundColor() {
        return (Color)ChartUtils.BLUE_STEEL2_LIGHT;
    }

    protected void createLegendBlock(BlockContainer blockcontainerLabel) {
        XYPlot xyplot = (XYPlot)this.report.getPlot();
        int nbRenderer = xyplot.getDatasetCount();
        BlockContainer blockcontainer = new BlockContainer((Arrangement)new BorderArrangement());
        if (nbRenderer > 1) {
            BlockContainer oldLegendBlockContainer = new BlockContainer((Arrangement)new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 2.0, 2.0));
            for (int i = 0; i < nbRenderer; ++i) {
                LegendTitle legendtitle = new LegendTitle((LegendItemSource)xyplot.getRenderer(i));
                legendtitle.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
                legendtitle.setFrame((BlockFrame)new LineBorder());
                legendtitle.setBackgroundPaint((Paint)ChartColor.WHITE);
                oldLegendBlockContainer.add((Block)legendtitle);
            }
            blockcontainer.add((Block)oldLegendBlockContainer, (Object)RectangleEdge.LEFT);
        } else {
            LegendTitle legendtitle = new LegendTitle((LegendItemSource)xyplot.getRenderer(0));
            legendtitle.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
            legendtitle.setFrame((BlockFrame)new LineBorder());
            legendtitle.setBackgroundPaint((Paint)ChartColor.WHITE);
            blockcontainer.add((Block)legendtitle, (Object)RectangleEdge.LEFT);
        }
        LegendTitle legendtitle1 = new LegendTitle((LegendItemSource)xyplot.getRenderer());
        legendtitle1.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        legendtitle1.setFrame((BlockFrame)new LineBorder());
        legendtitle1.setBackgroundPaint((Paint)ChartColor.WHITE);
        legendtitle1.setWrapper(blockcontainerLabel);
        blockcontainer.add((Block)legendtitle1, (Object)RectangleEdge.RIGHT);
        blockcontainer.add((Block)new EmptyBlock(1000.0, 0.0));
        CompositeTitle compositetitle = new CompositeTitle(blockcontainer);
        compositetitle.setPosition(RectangleEdge.BOTTOM);
        this.report.clearSubtitles();
        this.report.addSubtitle((Title)compositetitle);
    }

    protected Block createLegendItemBlock(LegendItem item, int i) {
        BlockContainer result = null;
        LegendGraphic lg = new LegendGraphic(item.getShape(), item.getFillPaint());
        lg.setFillPaintTransformer(item.getFillPaintTransformer());
        lg.setShapeFilled(true);
        lg.setLine(item.getLine());
        lg.setLineStroke(item.getLineStroke());
        lg.setLinePaint(item.getFillPaint());
        lg.setLineVisible(true);
        lg.setShapeVisible(true);
        lg.setShapeOutlineVisible(true);
        lg.setOutlinePaint(item.getFillPaint());
        lg.setOutlineStroke(item.getOutlineStroke());
        lg.setPadding(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        LegendItemBlockContainer legendItem = new LegendItemBlockContainer((Arrangement)new BorderArrangement(), 0, i);
        lg.setShapeAnchor(RectangleAnchor.CENTER);
        lg.setShapeLocation(RectangleAnchor.CENTER);
        legendItem.add((Block)lg, (Object)RectangleEdge.LEFT);
        LabelBlock labelBlock = new LabelBlock(item.getLabel(), new Font("SansSerif", 1, 10), (Paint)Color.black);
        labelBlock.setPadding(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        legendItem.add((Block)labelBlock);
        legendItem.setToolTipText(item.getToolTipText());
        legendItem.setURLText(item.getURLText());
        result = new BlockContainer((Arrangement)new CenterArrangement());
        result.add((Block)legendItem);
        return result;
    }
}

