/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.text.NumberFormat;
import java.util.Date;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;

public class CloverReportBean
extends AbstractReportBean {
    private int conditionals;
    private int statements;
    private int methods;
    private int elements;
    private int coveredConditionals;
    private int coveredStatements;
    private int coveredMethods;
    private int coveredElements;
    private static final NumberFormat FormatPercent = NumberFormat.getPercentInstance();

    public CloverReportBean() {
    }

    public CloverReportBean(Date dateGeneration) {
        super(dateGeneration);
    }

    public int getConditionals() {
        return this.conditionals;
    }

    public String getConditionalsLabel() {
        return this.getPercentage(this.coveredConditionals, this.conditionals) + " (" + this.coveredConditionals + " / " + this.conditionals + ")";
    }

    public void setConditionals(int conditionals) {
        this.conditionals = conditionals;
    }

    public int getCoveredConditionals() {
        return this.coveredConditionals;
    }

    public void setCoveredConditionals(int coveredConditionals) {
        this.coveredConditionals = coveredConditionals;
    }

    public int getCoveredElements() {
        return this.coveredElements;
    }

    public void setCoveredElements(int coveredElements) {
        this.coveredElements = coveredElements;
    }

    public int getCoveredMethods() {
        return this.coveredMethods;
    }

    public void setCoveredMethods(int coveredMethods) {
        this.coveredMethods = coveredMethods;
    }

    public int getCoveredStatements() {
        return this.coveredStatements;
    }

    public void setCoveredStatements(int coveredStatements) {
        this.coveredStatements = coveredStatements;
    }

    public int getElements() {
        return this.elements;
    }

    public String getElementsLabel() {
        return this.getPercentage(this.coveredElements, this.elements) + " (" + this.coveredElements + " / " + this.elements + ")";
    }

    public void setElements(int elements) {
        this.elements = elements;
    }

    public int getMethods() {
        return this.methods;
    }

    public String getMethodsLabel() {
        return this.getPercentage(this.coveredMethods, this.methods) + " (" + this.coveredMethods + " / " + this.methods + ")";
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    public int getStatements() {
        return this.statements;
    }

    public String getStatementsLabel() {
        return this.getPercentage(this.coveredStatements, this.statements) + " (" + this.coveredStatements + " / " + this.statements + ")";
    }

    public void setStatements(int statements) {
        this.statements = statements;
    }

    public void merge(IDashBoardReportBean dashboardReport) {
        if (dashboardReport != null && dashboardReport instanceof CloverReportBean) {
            this.conditionals += ((CloverReportBean)dashboardReport).getConditionals();
            this.statements += ((CloverReportBean)dashboardReport).getStatements();
            this.methods += ((CloverReportBean)dashboardReport).getMethods();
            this.elements += ((CloverReportBean)dashboardReport).getElements();
            this.coveredConditionals += ((CloverReportBean)dashboardReport).getCoveredConditionals();
            this.coveredStatements += ((CloverReportBean)dashboardReport).getCoveredStatements();
            this.coveredMethods += ((CloverReportBean)dashboardReport).getCoveredMethods();
            this.coveredElements += ((CloverReportBean)dashboardReport).getCoveredElements();
        }
    }

    private String getPercentage(int numerator, int denominator) {
        String percent = "0%";
        if (denominator > 0) {
            double percentage = (double)numerator / (double)denominator;
            percent = FormatPercent.format(percentage);
        }
        return percent;
    }

    public double getPercentCoveredStatements() {
        return this.getPercentageValue(this.coveredStatements, this.statements);
    }

    public double getPercentCoveredConditionals() {
        return this.getPercentageValue(this.coveredConditionals, this.conditionals);
    }

    public double getPercentCoveredElements() {
        return this.getPercentageValue(this.coveredElements, this.elements);
    }

    public double getPercentCoveredMethods() {
        return this.getPercentageValue(this.coveredMethods, this.methods);
    }

    public double getPercentUnCoveredStatements() {
        int uncovered = this.statements - this.coveredStatements;
        return this.getPercentageValue(uncovered, this.statements);
    }

    public double getPercentUnCoveredConditionals() {
        int uncovered = this.conditionals - this.coveredConditionals;
        return this.getPercentageValue(uncovered, this.conditionals);
    }

    public double getPercentUnCoveredElements() {
        int uncovered = this.elements - this.coveredElements;
        return this.getPercentageValue(uncovered, this.elements);
    }

    public double getPercentUnCoveredMethods() {
        int uncovered = this.methods - this.coveredMethods;
        return this.getPercentageValue(uncovered, this.methods);
    }

    static {
        FormatPercent.setMaximumFractionDigits(1);
    }
}

