/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xpp3;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugin.xpp3.AbstractXpp3Generator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;

public class Xpp3WriterGenerator
extends AbstractXpp3Generator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXpp3Writer();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating XPP3 Writer.", (Throwable)ex);
        }
    }

    private void generateXpp3Writer() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.xpp3";
        String marshallerName = this.getFileName("Xpp3Writer");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(packageName + '.' + marshallerName);
        this.initHeader(jClass);
        this.suppressAllWarnings(objectModel, (JStructure)jClass);
        jClass.addImport("org.codehaus.plexus.util.xml.pull.XmlSerializer");
        jClass.addImport("org.codehaus.plexus.util.xml.pull.MXSerializer");
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("java.util.Locale");
        JField namespaceField = new JField((JType)new JClass("String"), "NAMESPACE");
        namespaceField.getModifiers().setFinal(true);
        namespaceField.getModifiers().setStatic(true);
        namespaceField.setInitString("null");
        jClass.addField(namespaceField);
        this.addModelImports(jClass, null);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        String rootElement = this.resolveTagName(rootClass);
        JMethod marshall = new JMethod("write");
        String rootElementParameterName = Xpp3WriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("java.io.IOException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("XmlSerializer serializer = new MXSerializer();");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-indentation\", \"  \" );");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-line-separator\", \"\\n\" );");
        sc.add("serializer.setOutput( writer );");
        sc.add("serializer.startDocument( " + rootElementParameterName + ".getModelEncoding(), null );");
        sc.add("write" + root + "( " + rootElementParameterName + ", \"" + rootElement + "\", serializer );");
        sc.add("serializer.endDocument();");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            JavaClassMetadata javaClassMetadata = (JavaClassMetadata)clazz.getMetadata(JavaClassMetadata.ID);
            if (!javaClassMetadata.isEnabled()) continue;
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        String value;
        String type;
        String fieldTagName;
        JavaFieldMetadata javaFieldMetadata;
        XmlFieldMetadata xmlFieldMetadata;
        ModelField field;
        String className = modelClass.getName();
        String uncapClassName = Xpp3WriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod("write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        marshall.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        marshall.addException(new JClass("java.io.IOException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        sc.add("if ( " + uncapClassName + " != null )");
        sc.add("{");
        sc.indent();
        ModelClassMetadata classMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        String namespace = null;
        XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)modelClass.getModel().getMetadata(XmlModelMetadata.ID);
        if (classMetadata.isRootElement() && xmlModelMetadata.getNamespace() != null) {
            namespace = xmlModelMetadata.getNamespace(this.getGeneratedVersion());
            sc.add("serializer.setPrefix( \"\", \"" + namespace + "\" );");
        }
        if (namespace != null && xmlModelMetadata.getSchemaLocation() != null) {
            String url = xmlModelMetadata.getSchemaLocation(this.getGeneratedVersion());
            sc.add("serializer.setPrefix( \"xsi\", \"http://www.w3.org/2001/XMLSchema-instance\" );");
            sc.add("serializer.startTag( NAMESPACE, tagName );");
            sc.add("serializer.attribute( \"\", \"xsi:schemaLocation\", \"" + namespace + " " + url + "\" );");
        } else {
            sc.add("serializer.startTag( NAMESPACE, tagName );");
        }
        ModelField contentField = null;
        String contentValue = null;
        List modelFields = modelClass.getAllFields(this.getGeneratedVersion(), true);
        modelFields = this.getNonTransientFields(modelFields);
        Iterator i = modelFields.iterator();
        while (i.hasNext()) {
            field = (ModelField)i.next();
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            type = field.getType();
            value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isContent()) {
                contentField = field;
                contentValue = value;
                continue;
            }
            if (!xmlFieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.addIndented("serializer.attribute( NAMESPACE, \"" + fieldTagName + "\", " + this.getValue(field.getType(), value, xmlFieldMetadata) + " );");
            sc.add("}");
        }
        if (contentField != null) {
            XmlFieldMetadata xmlFieldMetadata2 = (XmlFieldMetadata)contentField.getMetadata(XmlFieldMetadata.ID);
            sc.add("serializer.text( " + this.getValue(contentField.getType(), contentValue, xmlFieldMetadata2) + " );");
        }
        Iterator fieldIterator = modelFields.iterator();
        while (fieldIterator.hasNext()) {
            field = (ModelField)fieldIterator.next();
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata.isContent()) continue;
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            type = field.getType();
            value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isAttribute()) continue;
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                String associationName = association.getName();
                if (association.isOneMultiplicity()) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.addIndented("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", \"" + fieldTagName + "\", serializer );");
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                String valuesTagName = this.resolveTagName(fieldTagName, xmlAssociationMetadata);
                type = association.getType();
                String toType = association.getTo();
                boolean wrappedItems = xmlAssociationMetadata.isWrappedItems();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    if (wrappedItems) {
                        sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        sc.add("write" + toType + "( o, \"" + valuesTagName + "\", serializer );");
                    } else {
                        sc.add(toType + " " + Xpp3WriterGenerator.singular((String)Xpp3WriterGenerator.uncapitalise((String)field.getName())) + " = (" + toType + ") iter.next();");
                        sc.add("serializer.startTag( NAMESPACE, \"" + valuesTagName + "\" ).text( " + Xpp3WriterGenerator.singular((String)Xpp3WriterGenerator.uncapitalise((String)field.getName())) + " ).endTag( NAMESPACE, " + "\"" + valuesTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    if (wrappedItems) {
                        sc.add("serializer.endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                if (wrappedItems) {
                    sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" );");
                }
                sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                sc.add("{");
                sc.indent();
                sc.add("String key = (String) iter.next();");
                sc.add("String value = (String) " + value + ".get( key );");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("serializer.startTag( NAMESPACE, \"" + Xpp3WriterGenerator.singular((String)associationName) + "\" );");
                    sc.add("serializer.startTag( NAMESPACE, \"key\" ).text( key ).endTag( NAMESPACE, \"key\" );");
                    sc.add("serializer.startTag( NAMESPACE, \"value\" ).text( value ).endTag( NAMESPACE, \"value\" );");
                    sc.add("serializer.endTag( NAMESPACE, \"" + Xpp3WriterGenerator.singular((String)associationName) + "\" );");
                } else {
                    sc.add("serializer.startTag( NAMESPACE, \"\" + key + \"\" ).text( value ).endTag( NAMESPACE, \"\" + key + \"\" );");
                }
                sc.unindent();
                sc.add("}");
                if (wrappedItems) {
                    sc.add("serializer.endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            if ("DOM".equals(field.getType())) {
                jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
                sc.addIndented("((Xpp3Dom) " + value + ").writeToSerializer( NAMESPACE, serializer );");
            } else {
                sc.addIndented("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" ).text( " + this.getValue(field.getType(), value, xmlFieldMetadata) + " ).endTag( NAMESPACE, " + "\"" + fieldTagName + "\" );");
            }
            sc.add("}");
        }
        sc.add("serializer.endTag( NAMESPACE, tagName );");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(marshall);
    }
}

