/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.converters;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.model.VersionDefinition;
import org.codehaus.modello.plugin.java.AbstractJavaModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JMethodSignature;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.plexus.util.IOUtil;

public class ConverterGenerator
extends AbstractJavaModelloGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        String[] versions = parameters.getProperty("modello.all.versions").split(",");
        ArrayList<Version> allVersions = new ArrayList<Version>(versions.length);
        for (String version : versions) {
            allVersions.add(new Version(version));
        }
        Collections.sort(allVersions);
        Version nextVersion = null;
        for (Version v : allVersions) {
            if (!v.greaterThan(this.getGeneratedVersion())) continue;
            nextVersion = v;
            break;
        }
        try {
            this.generateConverters(nextVersion);
            if (nextVersion == null) {
                this.generateConverterTool(allVersions);
            }
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating model converters.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConverters(Version toVersion) throws ModelloException, IOException {
        Model objectModel = this.getModel();
        Version fromVersion = this.getGeneratedVersion();
        String packageName = objectModel.getDefaultPackageName(true, fromVersion) + ".convert";
        Version effectiveToVersion = toVersion == null ? fromVersion : toVersion;
        String jDoc = "Converts from version " + fromVersion + " (with version in package name) to version " + effectiveToVersion + " (with" + (toVersion != null ? "" : "out") + " version in package name) of the model.";
        JInterface conversionInterface = new JInterface(packageName + ".VersionConverter");
        this.initHeader(conversionInterface);
        this.suppressAllWarnings(objectModel, (JStructure)conversionInterface);
        conversionInterface.getJDocComment().setComment(jDoc);
        JClass basicConverterClass = new JClass(packageName + ".BasicVersionConverter");
        this.initHeader(basicConverterClass);
        this.suppressAllWarnings(objectModel, (JStructure)basicConverterClass);
        basicConverterClass.getJDocComment().setComment(jDoc);
        basicConverterClass.addInterface(conversionInterface);
        VersionDefinition versionDefinition = objectModel.getVersionDefinition();
        for (ModelClass modelClass : objectModel.getClasses(fromVersion)) {
            JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
            if (!javaClassMetadata.isEnabled() || toVersion != null && !toVersion.inside(modelClass.getVersionRange())) continue;
            String methodName = "convert" + modelClass.getName();
            String parameterName = ConverterGenerator.uncapitalise((String)modelClass.getName());
            String sourceClass = ConverterGenerator.getSourceClassName(modelClass, fromVersion);
            String targetClass = modelClass.getPackageName(toVersion != null, toVersion) + "." + modelClass.getName();
            if (!javaClassMetadata.isAbstract()) {
                JMethodSignature methodSig = new JMethodSignature(methodName, new JType(targetClass));
                methodSig.addParameter(new JParameter(new JType(sourceClass), parameterName));
                conversionInterface.addMethod(methodSig);
                JMethod jMethod = new JMethod(methodName, new JType(targetClass), null);
                jMethod.addParameter(new JParameter(new JType(sourceClass), parameterName));
                basicConverterClass.addMethod(jMethod);
                JSourceCode sc = jMethod.getSourceCode();
                sc.add("return " + methodName + "( " + parameterName + ", new " + targetClass + "() );");
            }
            JMethod jMethod = new JMethod(methodName, new JType(targetClass), null);
            jMethod.addParameter(new JParameter(new JType(sourceClass), parameterName));
            jMethod.addParameter(new JParameter(new JType(targetClass), "value"));
            basicConverterClass.addMethod(jMethod);
            JSourceCode sc = jMethod.getSourceCode();
            sc.add("if ( " + parameterName + " == null )");
            sc.add("{");
            sc.indent();
            sc.add("return null;");
            sc.unindent();
            sc.add("}");
            if (modelClass.getSuperClass() != null) {
                sc.add("// Convert super class");
                sc.add("value = (" + targetClass + ") convert" + modelClass.getSuperClass() + "( " + parameterName + ", value );");
                sc.add("");
            }
            for (ModelField modelField : modelClass.getFields(fromVersion)) {
                String name = this.capitalise(modelField.getName());
                if (toVersion != null && versionDefinition != null && versionDefinition.isFieldType() && (versionDefinition.getValue().equals(modelField.getName()) || versionDefinition.getValue().equals(modelField.getAlias()))) {
                    sc.add("value.set" + name + "( \"" + toVersion + "\" );");
                    continue;
                }
                if (toVersion != null && !toVersion.inside(modelField.getVersionRange())) {
                    ModelField newField = null;
                    try {
                        newField = modelClass.getField(modelField.getName(), toVersion);
                    }
                    catch (ModelloRuntimeException e) {
                        continue;
                    }
                    if (!newField.getType().equals(modelField.getType())) continue;
                }
                if (modelField instanceof ModelAssociation) {
                    ModelAssociation assoc = (ModelAssociation)modelField;
                    if (assoc.isManyMultiplicity()) {
                        String className;
                        String type = assoc.getType();
                        if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                            sc.add("{");
                            sc.indent();
                            sc.add(assoc.getType() + " list = " + assoc.getDefaultValue() + ";");
                            sc.add("for ( java.util.Iterator i = " + parameterName + ".get" + name + "().iterator(); i.hasNext(); )");
                            sc.add("{");
                            sc.indent();
                            if (this.isClassInModel(assoc.getTo(), modelClass.getModel())) {
                                className = ConverterGenerator.getSourceClassName(assoc.getToClass(), fromVersion);
                                sc.add(className + " v = (" + className + ") i.next();");
                            } else {
                                sc.add(assoc.getTo() + " v = (" + assoc.getTo() + ") i.next();");
                            }
                            if (this.isClassInModel(assoc.getTo(), objectModel)) {
                                sc.add("list.add( convert" + assoc.getTo() + "( v ) );");
                            } else {
                                sc.add("list.add( v );");
                            }
                            sc.unindent();
                            sc.add("}");
                            sc.add("value.set" + name + "( list );");
                            sc.unindent();
                            sc.add("}");
                            continue;
                        }
                        sc.add("{");
                        sc.indent();
                        sc.add(assoc.getType() + " map = " + assoc.getDefaultValue() + ";");
                        sc.add("for ( java.util.Iterator i = " + parameterName + ".get" + name + "().entrySet().iterator(); i.hasNext(); )");
                        sc.add("{");
                        sc.indent();
                        sc.add("java.util.Map.Entry entry = (java.util.Map.Entry) i.next();");
                        if (this.isClassInModel(assoc.getTo(), modelClass.getModel())) {
                            className = ConverterGenerator.getSourceClassName(assoc.getToClass(), fromVersion);
                            sc.add(className + " v = (" + className + ") entry.getValue();");
                        } else {
                            sc.add(assoc.getTo() + " v = (" + assoc.getTo() + ") entry.getValue();");
                        }
                        if (this.isClassInModel(assoc.getTo(), objectModel)) {
                            sc.add("map.put( entry.getKey(), convert" + assoc.getTo() + "( v ) );");
                        } else {
                            sc.add("map.put( entry.getKey(), v );");
                        }
                        sc.unindent();
                        sc.add("}");
                        sc.add("value.set" + name + "( map );");
                        sc.unindent();
                        sc.add("}");
                        continue;
                    }
                    sc.add("value.set" + name + "( convert" + assoc.getTo() + "( " + parameterName + ".get" + name + "() ) );");
                    continue;
                }
                sc.add("// Convert field " + modelField.getName());
                JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
                String value = parameterName + "." + this.getPrefix(javaFieldMetadata) + name + "()";
                sc.add("value.set" + name + "( " + value + " );");
            }
            sc.add("");
            sc.add("return value;");
        }
        JSourceWriter interfaceWriter = null;
        JSourceWriter classWriter = null;
        try {
            interfaceWriter = this.newJSourceWriter(packageName, conversionInterface.getName(true));
            classWriter = this.newJSourceWriter(packageName, basicConverterClass.getName(true));
            conversionInterface.print(interfaceWriter);
            basicConverterClass.print(classWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(classWriter);
            IOUtil.close(interfaceWriter);
            throw throwable;
        }
        IOUtil.close((Writer)classWriter);
        IOUtil.close((Writer)interfaceWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConverterTool(List<Version> allVersions) throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        String basePackage = objectModel.getDefaultPackageName(false, null);
        String packageName = basePackage + ".convert";
        String jDoc = "Converts between the available versions of the model.";
        JClass converterClass = new JClass(packageName + ".ConverterTool");
        this.initHeader(converterClass);
        this.suppressAllWarnings(objectModel, (JStructure)converterClass);
        converterClass.getJDocComment().setComment(jDoc);
        converterClass.addImport("java.io.File");
        converterClass.addImport("java.io.IOException");
        converterClass.addImport("javax.xml.stream.*");
        for (Version v : allVersions) {
            ConverterGenerator.writeConvertMethod(converterClass, objectModel, basePackage, allVersions, v, rootClass);
        }
        ConverterGenerator.writeConvertMethod(converterClass, objectModel, basePackage, allVersions, null, rootClass);
        JSourceWriter classWriter = null;
        try {
            classWriter = this.newJSourceWriter(packageName, converterClass.getName(true));
            converterClass.print(new JSourceWriter((Writer)classWriter));
        }
        catch (Throwable throwable) {
            IOUtil.close(classWriter);
            throw throwable;
        }
        IOUtil.close((Writer)classWriter);
    }

    private static void writeConvertMethod(JClass converterClass, Model objectModel, String basePackage, List<Version> allVersions, Version v, ModelClass rootClass) {
        String modelName = objectModel.getName();
        String rootClassName = rootClass.getName();
        String targetPackage = objectModel.getDefaultPackageName(v != null, v);
        String targetClass = targetPackage + "." + rootClassName;
        String methodName = "convertFromFile";
        if (v != null) {
            methodName = methodName + "_" + v.toString("v", "_");
        }
        JMethod method = new JMethod(methodName, new JType(targetClass), null);
        method.addParameter(new JParameter(new JType("File"), "f"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        converterClass.addMethod(method);
        JSourceCode sc = method.getSourceCode();
        sc.add(basePackage + ".io.stax." + modelName + "StaxReaderDelegate reader = new " + basePackage + ".io.stax." + modelName + "StaxReaderDelegate();");
        sc.add("Object value = reader.read( f );");
        String prefix = "";
        for (Version sourceVersion : allVersions) {
            String sourcePackage = objectModel.getDefaultPackageName(true, sourceVersion);
            String sourceClass = sourcePackage + "." + rootClassName;
            sc.add(prefix + "if ( value instanceof " + sourceClass + " )");
            sc.add("{");
            sc.indent();
            boolean foundFirst = false;
            for (Version targetVersion : allVersions) {
                if (!foundFirst) {
                    if (!targetVersion.equals((Object)sourceVersion)) continue;
                    foundFirst = true;
                }
                if (targetVersion.equals((Object)v)) break;
                String p = objectModel.getDefaultPackageName(true, targetVersion);
                String c = p + "." + rootClassName;
                sc.add("value = new " + p + ".convert.BasicVersionConverter().convert" + rootClassName + "( (" + c + ") value );");
            }
            sc.unindent();
            sc.add("}");
            prefix = "else ";
            if (!sourceVersion.equals((Object)v)) continue;
            break;
        }
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("throw new IllegalStateException( \"Can't find converter for class '\" + value.getClass() + \"'\" );");
        sc.unindent();
        sc.add("}");
        sc.add("return (" + targetClass + ") value;");
    }

    private static String getSourceClassName(ModelClass modelClass, Version generatedVersion) {
        return modelClass.getPackageName(true, generatedVersion) + "." + modelClass.getName();
    }
}

