/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.ser.ContainerSerializerBase;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.schema.JsonSchema;
import org.codehaus.jackson.schema.SchemaAware;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerSerializers {
    private ContainerSerializers() {
    }

    public static ContainerSerializerBase<?> indexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        return new IndexedListSerializer(elemType, staticTyping, vts);
    }

    public static ContainerSerializerBase<?> collectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        return new CollectionSerializer(elemType, staticTyping, vts);
    }

    public static ContainerSerializerBase<?> iteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        return new IteratorSerializer(elemType, staticTyping, vts);
    }

    public static ContainerSerializerBase<?> iterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        return new IterableSerializer(elemType, staticTyping, vts);
    }

    public static JsonSerializer<?> enumSetSerializer(JavaType enumType) {
        return new EnumSetSerializer(enumType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSetSerializer
    extends AsArraySerializer<EnumSet<? extends Enum<?>>> {
        public EnumSetSerializer(JavaType elemType) {
            super(EnumSet.class, elemType, true, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public void serializeContents(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            JsonSerializer<Object> enumSer = this._elementSerializer;
            for (Enum enum_ : value) {
                if (enumSer == null) {
                    enumSer = provider.findValueSerializer(enum_.getDeclaringClass());
                }
                enumSer.serialize(enum_, jgen, provider);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IterableSerializer
    extends AsArraySerializer<Iterable<?>> {
        public static final IterableSerializer instance = new IterableSerializer(null, false, null);

        public IterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
            super(Iterable.class, elemType, staticTyping, vts);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new IterableSerializer(this._elementType, this._staticTyping, vts);
        }

        @Override
        public void serializeContents(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (it.hasNext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IteratorSerializer
    extends AsArraySerializer<Iterator<?>> {
        public static final IteratorSerializer instance = new IteratorSerializer(null, false, null);

        public IteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
            super(Iterator.class, elemType, staticTyping, vts);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new IteratorSerializer(this._elementType, this._staticTyping, vts);
        }

        @Override
        public void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = value.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (value.hasNext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionSerializer
    extends AsArraySerializer<Collection<?>> {
        public static final CollectionSerializer instance = new CollectionSerializer(null, false, null);

        public CollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
            super(Collection.class, elemType, staticTyping, vts);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new CollectionSerializer(this._elementType, this._staticTyping, vts);
        }

        @Override
        public void serializeContents(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this._elementSerializer != null) {
                this.serializeContentsUsing(value, jgen, provider, this._elementSerializer);
                return;
            }
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                TypeSerializer typeSer = this._valueTypeSerializer;
                int i = 0;
                do {
                    Object elem = it.next();
                    try {
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                        } else {
                            JsonSerializer<Object> currSerializer;
                            Class<?> cc = elem.getClass();
                            if (cc == prevClass) {
                                currSerializer = prevSerializer;
                            } else {
                                prevSerializer = currSerializer = provider.findValueSerializer(cc);
                                prevClass = cc;
                            }
                            if (typeSer == null) {
                                currSerializer.serialize(elem, jgen, provider);
                            } else {
                                currSerializer.serializeWithType(elem, jgen, provider, typeSer);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, value, i);
                    }
                    ++i;
                } while (it.hasNext());
            }
        }

        public void serializeContentsUsing(Collection<?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                TypeSerializer typeSer = this._valueTypeSerializer;
                int i = 0;
                do {
                    Object elem = it.next();
                    try {
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                        } else if (typeSer == null) {
                            ser.serialize(elem, jgen, provider);
                        } else {
                            ser.serializeWithType(elem, jgen, provider, typeSer);
                        }
                        ++i;
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, value, i);
                    }
                } while (it.hasNext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexedListSerializer
    extends AsArraySerializer<List<?>> {
        public static final IndexedListSerializer instance = new IndexedListSerializer(null, false, null);

        public IndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
            super(List.class, elemType, staticTyping, vts);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new IndexedListSerializer(this._elementType, this._staticTyping, vts);
        }

        @Override
        public void serializeContents(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this._elementSerializer != null) {
                this.serializeContentsUsing(value, jgen, provider, this._elementSerializer);
                return;
            }
            if (this._valueTypeSerializer != null) {
                this.serializeTypedContents(value, jgen, provider);
                return;
            }
            int len = value.size();
            if (len > 0) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                for (int i = 0; i < len; ++i) {
                    Object elem = value.get(i);
                    try {
                        JsonSerializer<Object> currSerializer;
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                            continue;
                        }
                        Class<?> cc = elem.getClass();
                        if (cc == prevClass) {
                            currSerializer = prevSerializer;
                        } else {
                            prevSerializer = currSerializer = provider.findValueSerializer(cc);
                            prevClass = cc;
                        }
                        currSerializer.serialize(elem, jgen, provider);
                        continue;
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, value, i);
                    }
                }
            }
        }

        public void serializeContentsUsing(List<?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
            int len = value.size();
            if (len > 0) {
                TypeSerializer typeSer = this._valueTypeSerializer;
                for (int i = 0; i < len; ++i) {
                    Object elem = value.get(i);
                    try {
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                            continue;
                        }
                        if (typeSer == null) {
                            ser.serialize(elem, jgen, provider);
                            continue;
                        }
                        ser.serializeWithType(elem, jgen, provider, typeSer);
                        continue;
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, value, i);
                    }
                }
            }
        }

        public void serializeTypedContents(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value.size();
            if (len > 0) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                TypeSerializer typeSer = this._valueTypeSerializer;
                for (int i = 0; i < len; ++i) {
                    Object elem = value.get(i);
                    try {
                        JsonSerializer<Object> currSerializer;
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                            continue;
                        }
                        Class<?> cc = elem.getClass();
                        if (cc == prevClass) {
                            currSerializer = prevSerializer;
                        } else {
                            prevSerializer = currSerializer = provider.findValueSerializer(cc);
                            prevClass = cc;
                        }
                        currSerializer.serializeWithType(elem, jgen, provider, typeSer);
                        continue;
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, value, i);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AsArraySerializer<T>
    extends ContainerSerializerBase<T>
    implements ResolvableSerializer {
        protected final boolean _staticTyping;
        protected final JavaType _elementType;
        protected final TypeSerializer _valueTypeSerializer;
        protected JsonSerializer<Object> _elementSerializer;

        protected AsArraySerializer(Class<?> cls, JavaType et, boolean staticTyping, TypeSerializer vts) {
            super(cls, false);
            this._elementType = et;
            this._staticTyping = staticTyping || et != null && et.isFinal();
            this._valueTypeSerializer = vts;
        }

        @Override
        public final void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            this.serializeContents(value, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public final void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            typeSer.writeTypePrefixForArray(value, jgen);
            this.serializeContents(value, jgen, provider);
            typeSer.writeTypeSuffixForArray(value, jgen);
        }

        protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            JavaType javaType;
            ObjectNode o = this.createSchemaNode("array", true);
            JavaType contentType = null;
            if (typeHint != null && (contentType = (javaType = TypeFactory.type(typeHint)).getContentType()) == null && typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                contentType = TypeFactory.type(typeArgs[0]);
            }
            if (contentType == null && this._elementType != null) {
                contentType = this._elementType;
            }
            if (contentType != null) {
                JsonSerializer<Object> ser = provider.findValueSerializer(contentType);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }

        @Override
        public void resolve(SerializerProvider provider) throws JsonMappingException {
            if (this._staticTyping && this._elementType != null) {
                this._elementSerializer = provider.findValueSerializer(this._elementType);
            }
        }
    }
}

