/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.hello;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;

public class HelloPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;

    public HelloPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        this(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
    }

    public HelloPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, LayoutManager2 layout, Resources resources) {
        super(panel, parent, installData, layout, resources);
        String welcomeText = this.getString("HelloPanel.welcome1") + installData.getInfo().getAppName() + " " + installData.getInfo().getAppVersion() + this.getString("HelloPanel.welcome2");
        JLabel welcomeLabel = LabelFactory.create((String)welcomeText, (Icon)((Icon)parent.getIcons().get((Object)"host")), (int)10);
        welcomeLabel.setName(GuiId.HELLO_PANEL_LABEL.id);
        this.add(welcomeLabel, "nextLine");
        this.add(IzPanelLayout.createParagraphGap());
        ArrayList authors = installData.getInfo().getAuthors();
        if (!authors.isEmpty()) {
            String authorText = this.getString("HelloPanel.authors");
            JLabel appAuthorsLabel = LabelFactory.create((String)authorText, (Icon)((Icon)parent.getIcons().get((Object)"information")), (int)10);
            this.add(appAuthorsLabel, "nextLine");
            for (Info.Author author : authors) {
                String email = author.getEmail() != null && author.getEmail().length() > 0 ? " <" + author.getEmail() + ">" : "";
                JLabel label = LabelFactory.create((String)(" - " + author.getName() + email), (Icon)((Icon)parent.getIcons().get((Object)"empty")), (int)10);
                this.add(label, "nextLine");
            }
            this.add(IzPanelLayout.createParagraphGap());
        }
        if (installData.getInfo().getAppURL() != null) {
            String urlText = this.getString("HelloPanel.url") + installData.getInfo().getAppURL();
            JLabel appURLLabel = LabelFactory.create((String)urlText, (Icon)((Icon)parent.getIcons().get((Object)"bookmark")), (int)10);
            this.add(appURLLabel, "nextLine");
        }
        this.getLayoutHelper().completeLayout();
    }

    public boolean isValidated() {
        return true;
    }
}

