/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.InstallerRequirement;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import java.util.logging.Logger;

public class InstallerRequirementChecker
implements RequirementChecker {
    private final InstallData installData;
    private final RulesEngine rules;
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger(InstallerRequirementChecker.class.getName());

    public InstallerRequirementChecker(InstallData installData, RulesEngine rules, Prompt prompt) {
        this.installData = installData;
        this.rules = rules;
        this.prompt = prompt;
    }

    public boolean check() {
        boolean fail = false;
        Messages messages = this.installData.getMessages();
        for (InstallerRequirement requirement : this.installData.getInstallerRequirements()) {
            String id = requirement.getCondition();
            Condition condition = this.rules.getCondition(id);
            if (condition == null) {
                fail = true;
                logger.warning(id + " is not a valid condition.");
                break;
            }
            if (condition.isTrue()) continue;
            fail = true;
            String message = requirement.getMessage();
            if (message == null) break;
            String localizedMessage = messages.get(message, new Object[0]);
            this.prompt.message(Prompt.Type.ERROR, localizedMessage);
            break;
        }
        return !fail;
    }
}

