/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.util.AbstractFactory;
import groovy.util.Factory;
import groovy.util.FactoryInterceptorMetaClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class FactoryBuilderSupport
extends Binding {
    public static final String CURRENT_FACTORY = "_CURRENT_FACTORY_";
    public static final String PARENT_FACTORY = "_PARENT_FACTORY_";
    public static final String PARENT_NODE = "_PARENT_NODE_";
    public static final String CURRENT_NODE = "_CURRENT_NODE_";
    public static final String PARENT_CONTEXT = "_PARENT_CONTEXT_";
    public static final String OWNER = "owner";
    private static final Logger LOG = Logger.getLogger(FactoryBuilderSupport.class.getName());
    private LinkedList contexts = new LinkedList();
    private LinkedList attributeDelegates = new LinkedList();
    private List disposalClosures = new ArrayList();
    private Map factories = new HashMap();
    private Closure nameMappingClosure;
    private FactoryBuilderSupport proxyBuilder;
    private LinkedList preInstantiateDelegates = new LinkedList();
    private LinkedList postInstantiateDelegates = new LinkedList();
    private LinkedList postNodeCompletionDelegates = new LinkedList();

    public static void checkValueIsNull(Object value, Object name) {
        if (value != null) {
            throw new RuntimeException("'" + name + "' elements do not accept a value argument.");
        }
    }

    public static boolean checkValueIsType(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName());
        }
        return false;
    }

    public static boolean checkValueIsTypeNotString(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            if (value instanceof String) {
                return false;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName() + " or a String.");
        }
        return false;
    }

    public FactoryBuilderSupport() {
        this.proxyBuilder = this;
    }

    public FactoryBuilderSupport(Closure nameMappingClosure) {
        this.nameMappingClosure = nameMappingClosure;
        this.proxyBuilder = this;
    }

    public Map getFactories() {
        return Collections.unmodifiableMap(this.proxyBuilder.factories);
    }

    public Map getContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            return (Map)this.proxyBuilder.contexts.getFirst();
        }
        return null;
    }

    public Object getCurrent() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map context = (Map)this.proxyBuilder.contexts.getFirst();
            return context.get(CURRENT_NODE);
        }
        return null;
    }

    public Factory getCurrentFactory() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map context = (Map)this.proxyBuilder.contexts.getFirst();
            return (Factory)context.get(CURRENT_FACTORY);
        }
        return null;
    }

    public Factory getParentFactory() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map context = (Map)this.proxyBuilder.contexts.getFirst();
            return (Factory)context.get(PARENT_FACTORY);
        }
        return null;
    }

    public Object getParentNode() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map context = (Map)this.proxyBuilder.contexts.getFirst();
            return context.get(PARENT_NODE);
        }
        return null;
    }

    public Map getParentContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map context = (Map)this.proxyBuilder.contexts.getFirst();
            return (Map)context.get(PARENT_CONTEXT);
        }
        return null;
    }

    public Object invokeMethod(String methodName) {
        return this.proxyBuilder.invokeMethod(methodName, null);
    }

    public Object invokeMethod(String methodName, Object args) {
        Object name = this.proxyBuilder.getName(methodName);
        Object result = null;
        Map previousContext = this.proxyBuilder.getContext();
        try {
            result = this.proxyBuilder.doInvokeMethod(methodName, name, args);
        }
        catch (RuntimeException e) {
            if (this.proxyBuilder.contexts.contains(previousContext)) {
                while (this.proxyBuilder.getContext() != previousContext) {
                    this.proxyBuilder.popContext();
                }
            }
            throw e;
        }
        return result;
    }

    public Closure addAttributeDelegate(Closure attrDelegate) {
        this.proxyBuilder.attributeDelegates.addFirst(attrDelegate);
        return attrDelegate;
    }

    public void removeAttributeDelegate(Closure attrDelegate) {
        this.proxyBuilder.attributeDelegates.remove(attrDelegate);
    }

    public Closure addPreInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.preInstantiateDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePreInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.preInstantiateDelegates.remove(delegate);
    }

    public Closure addPostInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.postInstantiateDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePostInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.postInstantiateDelegates.remove(delegate);
    }

    public Closure addPostNodeCompletionDelegate(Closure delegate) {
        this.proxyBuilder.postNodeCompletionDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePostNodeCompletionDelegate(Closure delegate) {
        this.proxyBuilder.postNodeCompletionDelegates.remove(delegate);
    }

    public void registerBeanFactory(String theName, final Class beanClass) {
        this.proxyBuilder.registerFactory(theName, new AbstractFactory(){

            public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
                if (FactoryBuilderSupport.checkValueIsTypeNotString(value, name, beanClass)) {
                    return value;
                }
                return beanClass.newInstance();
            }
        });
    }

    public void registerFactory(String name, Factory factory) {
        this.proxyBuilder.factories.put(name, factory);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object node = null;
        Factory factory = this.proxyBuilder.resolveFactory(name, attributes, value);
        if (factory == null) {
            LOG.log(Level.WARNING, "Could not find match for name '" + name + "'");
            return null;
        }
        this.proxyBuilder.getContext().put(CURRENT_FACTORY, factory);
        this.proxyBuilder.preInstantiate(name, attributes, value);
        try {
            node = factory.newInstance(this, name, value, attributes);
            if (node == null) {
                LOG.log(Level.WARNING, "Factory for name '" + name + "' returned null");
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("For name: " + name + " created node: " + node);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
        this.proxyBuilder.postInstantiate(name, attributes, node);
        this.proxyBuilder.handleNodeAttributes(node, attributes);
        return node;
    }

    protected Factory resolveFactory(Object name, Map attributes, Object value) {
        return (Factory)this.proxyBuilder.factories.get(name);
    }

    private Object doInvokeMethod(String methodName, Object name, Object args) {
        Object node = null;
        Closure closure = null;
        List list = InvokerHelper.asList(args);
        if (this.proxyBuilder.getContexts().isEmpty()) {
            this.proxyBuilder.newContext();
        }
        switch (list.size()) {
            case 0: {
                node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, null);
                break;
            }
            case 1: {
                Object object = list.get(0);
                if (object instanceof Map) {
                    node = this.proxyBuilder.createNode(name, (Map)object, null);
                    break;
                }
                if (object instanceof Closure) {
                    closure = (Closure)object;
                    node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, null);
                    break;
                }
                node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, object);
                break;
            }
            case 2: {
                Object object1 = list.get(0);
                Object object2 = list.get(1);
                if (object1 instanceof Map) {
                    if (object2 instanceof Closure) {
                        closure = (Closure)object2;
                        node = this.proxyBuilder.createNode(name, (Map)object1, null);
                        break;
                    }
                    node = this.proxyBuilder.createNode(name, (Map)object1, object2);
                    break;
                }
                if (object2 instanceof Closure) {
                    closure = (Closure)object2;
                    node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, object1);
                    break;
                }
                if (object2 instanceof Map) {
                    node = this.proxyBuilder.createNode(name, (Map)object2, object1);
                    break;
                }
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
            case 3: {
                Object arg0 = list.get(0);
                Object arg1 = list.get(1);
                Object arg2 = list.get(2);
                if (arg0 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    node = this.proxyBuilder.createNode(name, (Map)arg0, arg1);
                    break;
                }
                if (arg1 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    node = this.proxyBuilder.createNode(name, (Map)arg1, arg0);
                    break;
                }
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
            default: {
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
        }
        if (node == null) {
            if (this.proxyBuilder.getContexts().size() == 1) {
                this.proxyBuilder.popContext();
            }
            return node;
        }
        Object current = this.proxyBuilder.getCurrent();
        if (current != null) {
            this.proxyBuilder.setParent(current, node);
        }
        if (closure != null) {
            if (this.proxyBuilder.getCurrentFactory().isLeaf()) {
                throw new RuntimeException("'" + name + "' doesn't support nesting.");
            }
            Factory parentFactory = this.proxyBuilder.getCurrentFactory();
            Map parentContext = this.proxyBuilder.getContext();
            this.proxyBuilder.newContext();
            this.proxyBuilder.getContext().put(OWNER, closure.getOwner());
            this.proxyBuilder.getContext().put(CURRENT_NODE, node);
            this.proxyBuilder.getContext().put(PARENT_FACTORY, parentFactory);
            this.proxyBuilder.getContext().put(PARENT_NODE, current);
            this.proxyBuilder.getContext().put(PARENT_CONTEXT, parentContext);
            this.proxyBuilder.setClosureDelegate(closure, node);
            closure.call();
            this.proxyBuilder.popContext();
        }
        this.proxyBuilder.nodeCompleted(current, node);
        node = this.proxyBuilder.postNodeCompletion(current, node);
        if (this.proxyBuilder.getContexts().size() == 1) {
            this.proxyBuilder.popContext();
        }
        return node;
    }

    protected Object getName(String methodName) {
        if (this.proxyBuilder.nameMappingClosure != null) {
            return this.proxyBuilder.nameMappingClosure.call(methodName);
        }
        return methodName;
    }

    protected FactoryBuilderSupport getProxyBuilder() {
        return this.proxyBuilder;
    }

    protected void handleNodeAttributes(Object node, Map attributes) {
        if (node == null) {
            return;
        }
        Iterator iter = this.proxyBuilder.attributeDelegates.iterator();
        while (iter.hasNext()) {
            ((Closure)iter.next()).call(new Object[]{this, node, attributes});
        }
        if (this.proxyBuilder.getCurrentFactory().onHandleNodeAttributes(this, node, attributes)) {
            this.proxyBuilder.setNodeAttributes(node, attributes);
        }
    }

    protected void newContext() {
        this.proxyBuilder.contexts.addFirst(new HashMap());
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.proxyBuilder.getCurrentFactory().onNodeCompleted(this, parent, node);
    }

    protected Map popContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            return (Map)this.proxyBuilder.contexts.removeFirst();
        }
        return null;
    }

    protected void postInstantiate(Object name, Map attributes, Object node) {
        Iterator iter = this.proxyBuilder.postInstantiateDelegates.iterator();
        while (iter.hasNext()) {
            ((Closure)iter.next()).call(new Object[]{this, node, attributes});
        }
    }

    protected Object postNodeCompletion(Object parent, Object node) {
        Iterator iter = this.proxyBuilder.postNodeCompletionDelegates.iterator();
        while (iter.hasNext()) {
            ((Closure)iter.next()).call(new Object[]{this, parent, node});
        }
        return node;
    }

    protected void preInstantiate(Object name, Map attributes, Object value) {
        Iterator iter = this.proxyBuilder.preInstantiateDelegates.iterator();
        while (iter.hasNext()) {
            ((Closure)iter.next()).call(new Object[]{this, value, attributes});
        }
    }

    protected void reset() {
        this.proxyBuilder.contexts.clear();
    }

    protected void setClosureDelegate(Closure closure, Object node) {
        closure.setDelegate(this);
    }

    protected void setNodeAttributes(Object node, Map attributes) {
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String property = entry.getKey().toString();
            Object value = entry.getValue();
            InvokerHelper.setProperty(node, property, value);
        }
    }

    protected void setParent(Object parent, Object child) {
        this.proxyBuilder.getCurrentFactory().setParent(this, parent, child);
        Factory parentFactory = this.proxyBuilder.getParentFactory();
        if (parentFactory != null) {
            parentFactory.setChild(this, parent, child);
        }
    }

    protected void setProxyBuilder(FactoryBuilderSupport proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
    }

    protected LinkedList getContexts() {
        return this.proxyBuilder.contexts;
    }

    public Object build(Class viewClass) {
        if (Script.class.isAssignableFrom(viewClass)) {
            Script script = InvokerHelper.createScript(viewClass, this);
            return this.build(script);
        }
        throw new RuntimeException("Only scripts can be executed via build(Class)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object build(Script script) {
        Script script2 = script;
        synchronized (script2) {
            Object object;
            MetaClass scriptMetaClass = script.getMetaClass();
            try {
                script.setMetaClass(new FactoryInterceptorMetaClass(scriptMetaClass, this));
                script.setBinding(this);
                object = script.run();
            }
            catch (Throwable throwable) {
                script.setMetaClass(scriptMetaClass);
                throw throwable;
            }
            script.setMetaClass(scriptMetaClass);
            return object;
        }
    }

    public Object build(String script, GroovyClassLoader loader) {
        return this.build(loader.parseClass(script));
    }

    public Object withBuilder(FactoryBuilderSupport builder, Closure closure) {
        if (builder == null || closure == null) {
            return null;
        }
        Object result = null;
        Map previousContext = this.proxyBuilder.getContext();
        FactoryBuilderSupport previousProxyBuilder = this.proxyBuilder;
        try {
            this.proxyBuilder = builder;
            closure.setDelegate(builder);
            result = closure.call();
        }
        catch (RuntimeException e) {
            this.proxyBuilder = previousProxyBuilder;
            if (this.proxyBuilder.contexts.contains(previousContext)) {
                while (this.proxyBuilder.getContext() != previousContext) {
                    this.proxyBuilder.popContext();
                }
            }
            throw e;
        }
        finally {
            this.proxyBuilder = previousProxyBuilder;
        }
        return result;
    }

    public Object withBuilder(FactoryBuilderSupport builder, String name, Closure closure) {
        if (name == null) {
            return null;
        }
        Object result = this.proxyBuilder.withBuilder(builder, closure);
        return this.proxyBuilder.invokeMethod(name, new Object[]{result});
    }

    public Object withBuilder(Map attributes, FactoryBuilderSupport builder, String name, Closure closure) {
        if (name == null) {
            return null;
        }
        Object result = this.proxyBuilder.withBuilder(builder, closure);
        return this.proxyBuilder.invokeMethod(name, new Object[]{attributes, result});
    }

    public void addDisposalClosure(Closure closure) {
        this.disposalClosures.add(closure);
    }

    public void dispose() {
        for (int i = this.disposalClosures.size() - 1; i >= 0; --i) {
            ((Closure)this.disposalClosures.get(i)).call();
        }
    }
}

