/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.exolab.castor.builder.BaseFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.EnumerationFactory;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.MemberFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JCollectionType;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class SourceFactory
extends BaseFactory {
    private static final String ENUM_ACCESS_INTERFACE = "org.exolab.castor.types.EnumeratedTypeAccess";
    private static final short BASE_TYPE_ENUMERATION = 0;
    private static final short OBJECT_TYPE_ENUMERATION = 1;
    private static final String CLASS_METHOD_SUFFIX = "Class";
    private static final String CLASS_KEYWORD = "class";
    private static final String ITEM_NAME = "Item";
    private ExtendedBinding _binding = null;
    private MemberFactory _memberFactory = null;
    private short _enumerationType = 1;
    private boolean _createMarshalMethods = true;
    private boolean _testable = false;
    private boolean _sax1 = false;
    private TypeConversion _typeConversion = null;
    private final EnumerationFactory _enumerationFactory;

    public SourceFactory(BuilderConfiguration config, FieldInfoFactory infoFactory, GroupNaming groupNaming) {
        super(config, infoFactory, groupNaming);
        infoFactory.setBoundProperties(config.boundPropertiesEnabled());
        this._memberFactory = new MemberFactory(config, infoFactory, this.getGroupNaming());
        this._typeConversion = new TypeConversion(this.getConfig());
        this._enumerationFactory = new EnumerationFactory(this.getConfig(), this.getGroupNaming());
    }

    public void setCreateMarshalMethods(boolean createMarshalMethods) {
        this._createMarshalMethods = createMarshalMethods;
    }

    public void setCreateExtraMethods(boolean extraMethods) {
        this.getInfoFactory().setCreateExtraMethods(extraMethods);
    }

    public void setReferenceMethodSuffix(String suffix) {
        this.getInfoFactory().setReferenceMethodSuffix(suffix);
    }

    public void setTestable(boolean testable) {
        this._testable = testable;
    }

    public void setSAX1(boolean sax1) {
        this._sax1 = sax1;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._enumerationFactory.setCaseInsensitive(caseInsensitive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JClass[] createSourceCode(XMLBindingComponent component, SGStateInfo sgState) {
        String comment;
        String[] implemented;
        boolean createGroupItem;
        String className;
        String packageName;
        if (component == null) {
            throw new IllegalStateException("XMLBindingComponent may not be null.");
        }
        if (sgState == null) {
            throw new IllegalStateException("SGStateInfo may not be null.");
        }
        JClass[] classes = sgState.getSourceCode(component.getAnnotated());
        if (classes != null) {
            return classes;
        }
        this._binding = component.getBinding();
        if (sgState.verbose()) {
            String name = component.getXMLName();
            if (name == null) {
                name = component.getJavaClassName();
            }
            String msg = "Creating classes for: " + name;
            sgState.getDialog().notify(msg);
        }
        if ((packageName = component.getJavaPackage()) == null || packageName.length() == 0) {
            packageName = sgState.getPackageName();
        }
        if ((className = component.getQualifiedName()).indexOf(46) == -1) {
            className = JavaNaming.toJavaClassName((String)className);
            className = this.resolveClassName(className, packageName);
        }
        if (createGroupItem = component.createGroupItem()) {
            className = className + ITEM_NAME;
            classes = new JClass[2];
        } else {
            classes = new JClass[1];
        }
        FactoryState state = new FactoryState(className, sgState, packageName);
        state.setCreateGroupItem(createGroupItem);
        if (sgState.getCurrentFactoryState() != null) {
            state.setParent(sgState.getCurrentFactoryState());
        }
        sgState.setCurrentFactoryState(state);
        if (state.processed(component.getAnnotated())) {
            return new JClass[0];
        }
        state.markAsProcessed(component.getAnnotated());
        ClassInfo classInfo = state.getClassInfo();
        JClass jClass = state.getJClass();
        this.initialize(jClass);
        classInfo.setNodeName(component.getXMLName());
        classInfo.setNamespaceURI(component.getTargetNamespace());
        XMLType type = component.getXMLType();
        boolean createForSingleGroup = false;
        boolean creatingForAnElement = component.getAnnotated().getStructureType() == 8;
        classInfo.setElementDefinition(creatingForAnElement);
        if (type != null) {
            if (type.isComplexType()) {
                this.processComplexType(component, sgState, state);
            } else if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                if (!simpleType.hasFacet("enumeration")) return new JClass[0];
                this.processSimpleTypeEnumeration(component, sgState, classInfo, simpleType);
            } else if (type.isAnyType()) {
                classInfo.setSchemaType(new XSClass(SGTypes.OBJECT));
                return new JClass[0];
            }
        } else {
            createForSingleGroup = this.processSchemaGroup(component, state, classInfo);
        }
        if (createGroupItem) {
            ComplexType complexType;
            if (component.hasBoundProperties()) {
                this.createPropertyChangeMethods(jClass);
            }
            sgState.bindReference(jClass, classInfo);
            classes[1] = jClass;
            String fname = component.getJavaClassName() + ITEM_NAME;
            fname = JavaNaming.toJavaMemberName((String)fname, (boolean)false);
            FieldInfo fInfo = null;
            fInfo = createForSingleGroup ? this.getInfoFactory().createFieldInfo(new XSClass(jClass), fname) : this.getInfoFactory().createCollection(new XSClass(jClass), "_items", fname, this.getConfig().useJava50());
            fInfo.setContainer(true);
            String newClassName = className.substring(0, className.length() - 4);
            state = new FactoryState(newClassName, sgState, packageName);
            classInfo = state.getClassInfo();
            jClass = state.getJClass();
            this.initialize(jClass);
            if (type != null && type.isComplexType() && (complexType = (ComplexType)type).isTopLevel() ^ creatingForAnElement) {
                Annotated saved = component.getAnnotated();
                this.processAttributes(component.getBinding(), complexType, state);
                component.setView(saved);
                if (complexType.getContentType() == ContentType.mixed) {
                    FieldInfo fieldInfo = this._memberFactory.createFieldInfoForContent(new XSString(), this.getConfig().useJava50());
                    this.handleField(fieldInfo, state);
                } else if (complexType.getContentType().getType() == 4) {
                    SimpleContent simpleContent = (SimpleContent)complexType.getContentType();
                    SimpleType temp = simpleContent.getSimpleType();
                    XSType xsType = this._typeConversion.convertType(temp, packageName, this.getConfig().useJava50());
                    FieldInfo fieldInfo = this._memberFactory.createFieldInfoForContent(xsType, this.getConfig().useJava50());
                    this.handleField(fieldInfo, state);
                    temp = null;
                } else {
                    classInfo.setSchemaType(new XSClass(jClass));
                }
            }
            classInfo.addFieldInfo(fInfo);
            fInfo.createJavaField(jClass);
            fInfo.createAccessMethods(jClass, this.getConfig().useJava50());
            fInfo.generateInitializerCode(jClass.getConstructor(0).getSourceCode());
            classInfo.setNodeName(component.getXMLName());
            classInfo.setContainer(true);
            String actSuperClass = classes[1].getSuperClassQualifiedName();
            jClass.setSuperClass(actSuperClass);
            classes[1].setSuperClass(null);
        }
        classes[0] = jClass;
        String baseClass = component.getExtends();
        if (baseClass != null && baseClass.length() > 0 && jClass.getSuperClassQualifiedName() == null) {
            jClass.setSuperClass(baseClass);
        }
        if ((implemented = component.getImplements()) != null) {
            for (int i = 0; i < implemented.length; ++i) {
                String interfaceName = implemented[i];
                if (interfaceName == null || interfaceName.length() <= 0) continue;
                jClass.addInterface(interfaceName);
            }
        }
        jClass.getModifiers().setFinal(component.isFinal());
        if (component.isAbstract()) {
            jClass.getModifiers().setAbstract(true);
            classInfo.setAbstract(true);
        }
        if ((comment = this.processAnnotations(component.getAnnotated())) != null) {
            jClass.getJDocComment().setComment(comment);
        }
        this.makeMethods(component, sgState, state, jClass, baseClass);
        sgState.bindReference(jClass, classInfo);
        sgState.bindReference(component.getAnnotated(), classInfo);
        sgState.bindSourceCode(component.getAnnotated(), classes);
        return classes;
    }

    private void makeMethods(XMLBindingComponent component, SGStateInfo sgState, FactoryState state, JClass jClass, String baseClass) {
        String superclassQualifiedName;
        if (this._createMarshalMethods) {
            this.createValidateMethods(jClass);
            if (!component.isAbstract()) {
                this.createMarshalMethods(jClass);
                this.createUnmarshalMethods(jClass, sgState);
            }
        }
        if (component.hasEquals()) {
            this.createEqualsMethod(jClass);
            SourceFactory.createHashCodeMethod(jClass);
        }
        if (this._testable) {
            this.createTestableMethods(jClass, state);
        }
        if (((superclassQualifiedName = jClass.getSuperClassQualifiedName()) == null || superclassQualifiedName.equals(baseClass)) && component.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
    }

    private boolean processSchemaGroup(XMLBindingComponent component, FactoryState state, ClassInfo classInfo) {
        try {
            Group group = (Group)component.getAnnotated();
            this.processContentModel((ContentModelGroup)group, state);
            component.setView((Annotated)group);
            Order order = group.getOrder();
            if (order == Order.choice) {
                classInfo.getGroupInfo().setAsChoice();
            } else if (order == Order.seq) {
                classInfo.getGroupInfo().setAsSequence();
            } else {
                classInfo.getGroupInfo().setAsAll();
            }
            return group.getMaxOccurs() == 1;
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("Illegal binding component: " + ce.getMessage());
        }
    }

    private void processSimpleTypeEnumeration(XMLBindingComponent component, SGStateInfo sgState, ClassInfo classInfo, SimpleType simpleType) {
        String tns = simpleType.getSchema().getTargetNamespace();
        boolean create = false;
        create = tns == null ? component.getTargetNamespace() == null : tns.equals(component.getTargetNamespace());
        if (create) {
            ClassInfo tmpInfo = sgState.resolve(simpleType);
            JClass tmpClass = null;
            tmpClass = tmpInfo != null ? tmpInfo.getJClass() : this.createSourceCode(component.getBinding(), simpleType, sgState);
            classInfo.setSchemaType(new XSClass(tmpClass));
        }
    }

    private void processComplexType(XMLBindingComponent component, SGStateInfo sgState, FactoryState state) {
        XMLType type = component.getXMLType();
        ClassInfo classInfo = state.getClassInfo();
        JClass jClass = state.getJClass();
        boolean creatingForAnElement = component.getAnnotated().getStructureType() == 8;
        ComplexType complexType = (ComplexType)type;
        if (complexType.isTopLevel() && creatingForAnElement) {
            Annotated saved = component.getAnnotated();
            String previousPackage = component.getJavaPackage();
            XMLBindingComponent baseComponent = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
            baseComponent.setBinding(component.getBinding());
            baseComponent.setView((Annotated)complexType);
            this.createSourceCode(baseComponent, sgState);
            String baseClassName = null;
            String basePackage = baseComponent.getJavaPackage();
            if (basePackage != null && !basePackage.equals(previousPackage)) {
                baseClassName = baseComponent.getQualifiedName();
                if (baseClassName.indexOf(46) == -1) {
                    baseClassName = JavaNaming.toJavaClassName((String)baseClassName);
                }
            } else {
                baseClassName = baseComponent.getJavaClassName();
            }
            jClass.setSuperClass(baseClassName);
            basePackage = null;
            baseClassName = null;
            component.setView(saved);
            saved = null;
        } else if (complexType.isTopLevel() || creatingForAnElement) {
            Group group;
            Particle particle;
            if (complexType.getParticleCount() == 1 && (particle = complexType.getParticle(0)).getStructureType() == 10 && (group = (Group)particle).getOrder() == Order.choice) {
                classInfo.getGroupInfo().setAsChoice();
            }
            Annotated saved = component.getAnnotated();
            this.processComplexType(complexType, state);
            component.setView(saved);
            saved = null;
        }
    }

    public JClass createSourceCode(ExtendedBinding binding, SimpleType simpleType, SGStateInfo sgState) {
        String boundClassName;
        if (SimpleTypesFactory.isBuiltInType((int)simpleType.getTypeCode())) {
            String err = "You cannot construct a ClassInfo for a built-in SimpleType.";
            throw new IllegalArgumentException(err);
        }
        if (sgState == null) {
            throw new IllegalArgumentException("SGStateInfo cannot be null.");
        }
        if (simpleType.getStructureType() == 22) {
            if (!sgState.getSuppressNonFatalWarnings()) {
                String message = "warning: support for unions is incomplete.";
                sgState.getDialog().notify(message);
            }
            return null;
        }
        ClassInfo cInfo = sgState.resolve(simpleType);
        if (cInfo != null) {
            return cInfo.getJClass();
        }
        boolean enumeration = false;
        String typeName = simpleType.getName();
        if (typeName == null) {
            Structure struct = simpleType.getParent();
            FactoryState fstate = null;
            switch (struct.getStructureType()) {
                case 3: {
                    typeName = ((AttributeDecl)struct).getName();
                    fstate = sgState.getCurrentFactoryState();
                    break;
                }
                case 8: {
                    typeName = ((ElementDecl)struct).getName();
                    break;
                }
            }
            if (fstate != null) {
                typeName = JavaNaming.toJavaClassName((String)typeName);
                Structure attrDeclParent = ((AttributeDecl)struct).getParent();
                typeName = attrDeclParent != null && attrDeclParent.getStructureType() == 4 ? JavaNaming.toJavaClassName((String)(((AttributeGroupDecl)attrDeclParent).getName() + typeName)) : fstate.getJClass().getLocalName() + typeName;
            }
            typeName = typeName + "Type";
        }
        String className = JavaNaming.toJavaClassName((String)typeName);
        XMLBindingComponent comp = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (binding != null) {
            comp.setBinding(binding);
        }
        comp.setView((Annotated)simpleType);
        String packageName = comp.getJavaPackage();
        if (packageName == null || packageName.length() == 0) {
            packageName = sgState.getPackageName();
        }
        if (simpleType.hasFacet("enumeration")) {
            enumeration = true;
            packageName = packageName != null && packageName.length() > 0 ? packageName + "." + "types" : "types";
        }
        if ((boundClassName = comp.getJavaClassName()) != null && boundClassName.length() > 0) {
            className = boundClassName;
            typeName = boundClassName;
        }
        className = this.resolveClassName(className, packageName);
        FactoryState state = new FactoryState(className, sgState, packageName);
        state.setParent(sgState.getCurrentFactoryState());
        ClassInfo classInfo = state.getClassInfo();
        JClass jClass = state.getJClass();
        this.initialize(jClass);
        Schema schema = simpleType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        classInfo.setNodeName(typeName);
        String comment = this.processAnnotations((Annotated)simpleType);
        if (comment != null) {
            jClass.getJDocComment().setComment(comment);
        }
        XSClass xsClass = new XSClass(jClass, typeName);
        classInfo.setSchemaType(xsClass);
        if (enumeration) {
            xsClass.setAsEnumerated(true);
            this.processEnumeration(binding, simpleType, state);
        }
        if (state.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sgState.bindReference(jClass, classInfo);
        sgState.bindReference(simpleType, classInfo);
        return jClass;
    }

    private void initialize(JClass jClass) {
        jClass.addInterface("java.io.Serializable");
        if (this.getConfig().useJava50()) {
            JAnnotation serial = new JAnnotation(new JAnnotationType("SuppressWarnings"));
            serial.setValue(new String[]{"\"serial\""});
            jClass.addAnnotation(serial);
        }
        JConstructor con = jClass.createConstructor();
        jClass.addConstructor(con);
        con.getSourceCode().add("super();");
    }

    private void createPropertyChangeMethods(JClass parent) {
        parent.addImport("java.beans.PropertyChangeEvent");
        parent.addImport("java.beans.PropertyChangeListener");
        String vName = "propertyChangeSupport";
        JField field = new JField(SGTypes.PROPERTY_CHANGE_SUPPORT, vName);
        field.getModifiers().makePrivate();
        parent.addField(field);
        JMethod jMethod = new JMethod("notifyPropertyChangeListeners");
        jMethod.getModifiers().makeProtected();
        JDocComment jdc = jMethod.getJDocComment();
        JDocDescriptor jdDesc = null;
        String desc = null;
        desc = "Notifies all registered PropertyChangeListeners when a bound property's value changes.";
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(SGTypes.STRING, "fieldName"));
        jdDesc = jdc.getParamDescriptor("fieldName");
        jdDesc.setDescription("the name of the property that has changed.");
        jMethod.addParameter(new JParameter(SGTypes.OBJECT, "oldValue"));
        jdDesc = jdc.getParamDescriptor("oldValue");
        jdDesc.setDescription("the old value of the property.");
        jMethod.addParameter(new JParameter(SGTypes.OBJECT, "newValue"));
        jdDesc = jdc.getParamDescriptor("newValue");
        jdDesc.setDescription("the new value of the property.");
        parent.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) return;");
        jsc.add(vName);
        jsc.append(".firePropertyChange(fieldName,oldValue,newValue);");
        JClass jType = new JClass("java.beans.PropertyChangeListener");
        jMethod = new JMethod("addPropertyChangeListener");
        desc = "Registers a PropertyChangeListener with this class.";
        jdc = jMethod.getJDocComment();
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(jType, "pcl"));
        desc = "The PropertyChangeListener to register.";
        jdDesc = jdc.getParamDescriptor("pcl");
        jdDesc.setDescription(desc);
        parent.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) {");
        jsc.addIndented(vName + " = new java.beans.PropertyChangeSupport(this);");
        jsc.add("}");
        jsc.add(vName);
        jsc.append(".addPropertyChangeListener(pcl);");
        jMethod = new JMethod("removePropertyChangeListener", JType.BOOLEAN, "always returns true if pcl != null");
        desc = "Removes the given PropertyChangeListener from this classes list of ProperyChangeListeners.";
        jdc = jMethod.getJDocComment();
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(jType, "pcl"));
        desc = "The PropertyChangeListener to remove.";
        jdDesc = jdc.getParamDescriptor("pcl");
        jdDesc.setDescription(desc);
        parent.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) return false;");
        jsc.add(vName);
        jsc.append(".removePropertyChangeListener(pcl);");
        jsc.add("return true;");
    }

    private void createMarshalMethods(JClass parent) {
        this.createMarshalMethods(parent, false);
    }

    private void createMarshalMethods(JClass parent, boolean isAbstract) {
        JMethod jMethod = new JMethod("marshal");
        jMethod.addException(SGTypes.MARSHAL_EXCEPTION, "if object is null or if any SAXException is thrown during marshaling");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jMethod.addParameter(new JParameter(SGTypes.WRITER, "out"));
        parent.addMethod(jMethod);
        if (isAbstract) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jsc = jMethod.getSourceCode();
            jsc.add("Marshaller.marshal(this, out);");
        }
        jMethod = new JMethod("marshal");
        JClass jc = null;
        if (this._sax1) {
            jc = new JClass("org.xml.sax.DocumentHandler");
        } else {
            jc = new JClass("org.xml.sax.ContentHandler");
            jMethod.addException(SGTypes.IO_EXCEPTION, "if an IOException occurs during marshaling");
        }
        jMethod.addException(SGTypes.MARSHAL_EXCEPTION, "if object is null or if any SAXException is thrown during marshaling");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jMethod.addParameter(new JParameter(jc, "handler"));
        parent.addMethod(jMethod);
        if (isAbstract) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jsc = jMethod.getSourceCode();
            jsc = jMethod.getSourceCode();
            jsc.add("Marshaller.marshal(this, handler);");
        }
        parent.addImport("org.exolab.castor.xml.Marshaller");
        parent.addImport("org.exolab.castor.xml.Unmarshaller");
    }

    private void createUnmarshalMethods(JClass parent, SGStateInfo sgState) {
        String methodName = "unmarshal";
        if (sgState.getSourceGenerator().mappingSchemaType2Java()) {
            methodName = methodName + parent.getLocalName();
        }
        JClass returnType = this.findBaseClass(parent, sgState);
        JMethod jMethod = new JMethod(methodName, returnType, "the unmarshaled " + returnType.getName());
        jMethod.getModifiers().setStatic(true);
        jMethod.addException(SGTypes.MARSHAL_EXCEPTION, "if object is null or if any SAXException is thrown during marshaling");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jMethod.addParameter(new JParameter(SGTypes.READER, "reader"));
        parent.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("return (");
        jsc.append(returnType.getName());
        jsc.append(") Unmarshaller.unmarshal(");
        jsc.append(parent.getName());
        jsc.append(".class, reader);");
    }

    private JClass findBaseClass(JClass jClass, SGStateInfo sgState) {
        JClass returnType = jClass;
        LinkedList<JClass> classes = new LinkedList<JClass>();
        classes.add(returnType);
        while (returnType.getSuperClassQualifiedName() != null) {
            String pkgName;
            String superClassName = returnType.getSuperClassQualifiedName();
            JClass superClass = sgState.getSourceCode(superClassName);
            if (superClass == null) {
                superClass = sgState.getImportedSourceCode(superClassName);
            }
            if (superClass == null && superClassName.indexOf(46) < 0 && (pkgName = returnType.getPackageName()) != null && pkgName.length() > 0) {
                superClassName = pkgName + "." + superClassName;
                superClass = sgState.getSourceCode(superClassName);
            }
            if (superClass == null) break;
            if (classes.contains(superClass)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Loop found in class hierarchy: ");
                Iterator i = classes.iterator();
                while (i.hasNext()) {
                    JClass element = (JClass)i.next();
                    buffer.append(element.getName());
                    buffer.append(" -> ");
                }
                buffer.append(superClass.getName());
                sgState.getDialog().notify(buffer.toString());
                break;
            }
            classes.add(superClass);
            returnType = superClass;
        }
        classes.clear();
        return returnType;
    }

    public static void createHashCodeMethod(JClass jclass) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        JField[] fields = jclass.getFields();
        JMethod jMethod = new JMethod("hashCode", JType.INT, "a hash code value for the object.");
        jMethod.setComment("Overrides the java.lang.Object.hashCode method.\n<p>\nThe following steps came from <b>Effective Java Programming Language Guide</b> by Joshua Bloch, Chapter 3");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("int result = 17;");
        jsc.add("");
        jsc.add("long tmp;");
        for (int i = 0; i < fields.length; ++i) {
            JField temp = fields[i];
            JType type = temp.getType();
            String name = temp.getName();
            if (type.isPrimitive()) {
                if (type == JType.BOOLEAN) {
                    if (name.startsWith("_has_") && jclass.getField(name.substring(5)) == null) continue;
                    jsc.add("result = 37 * result + (" + name + "?0:1);");
                    continue;
                }
                if (type == JType.BYTE || type == JType.INT || type == JType.SHORT) {
                    jsc.add("result = 37 * result + " + name + ";");
                    continue;
                }
                if (type == JType.LONG) {
                    jsc.add("result = 37 * result + (int)(" + name + "^(" + name + ">>>32));");
                    continue;
                }
                if (type == JType.FLOAT) {
                    jsc.add("result = 37 * result + java.lang.Float.floatToIntBits(" + name + ");");
                    continue;
                }
                if (type != JType.DOUBLE) continue;
                jsc.add("tmp = java.lang.Double.doubleToLongBits(" + name + ");");
                jsc.add("result = 37 * result + (int)(tmp^(tmp>>>32));");
                continue;
            }
            jsc.add("if (" + name + " != null) {");
            jsc.add("   result = 37 * result + " + name + ".hashCode();");
            jsc.add("}");
        }
        jsc.add("");
        jsc.add("return result;");
    }

    public void createEqualsMethod(JClass jclass) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        JField[] fields = jclass.getFields();
        JMethod jMethod = new JMethod("equals", JType.BOOLEAN, "true if the objects are equal.");
        jMethod.setComment("Overrides the java.lang.Object.equals method.");
        jMethod.addParameter(new JParameter(SGTypes.OBJECT, "obj"));
        if (this.getConfig().useJava50()) {
            jMethod.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("if ( this == obj )");
        jsc.indent();
        jsc.add("return true;");
        jsc.unindent();
        if (jclass.getSuperClassQualifiedName() != null) {
            jsc.add("");
            jsc.add("if (super.equals(obj)==false)");
            jsc.indent();
            jsc.add("return false;");
            jsc.unindent();
        }
        jsc.add("");
        jsc.add("if (obj instanceof ");
        jsc.append(jclass.getLocalName());
        jsc.append(") {");
        jsc.add("");
        if (fields.length > 0) {
            jsc.indent();
            jsc.add(jclass.getLocalName());
            jsc.append(" temp = (");
            jsc.append(jclass.getLocalName());
            jsc.append(")obj;");
        }
        for (int i = 0; i < fields.length; ++i) {
            JField temp = fields[i];
            String name = temp.getName();
            if (temp.getType().isPrimitive()) {
                jsc.add("if (this.");
                jsc.append(name);
                jsc.append(" != temp.");
                jsc.append(name);
                jsc.append(")");
            } else {
                jsc.add("if (this.");
                jsc.append(name);
                jsc.append(" != null) {");
                jsc.indent();
                jsc.add("if (temp.");
                jsc.append(name);
                jsc.append(" == null) ");
                jsc.indent();
                jsc.append("return false;");
                jsc.unindent();
                jsc.add("else if (!(");
                if (temp.getType().isArray()) {
                    jsc.append("java.util.Arrays.equals(this.");
                    jsc.append(name);
                    jsc.append(", temp.");
                    jsc.append(name);
                    jsc.append(")");
                } else {
                    jsc.append("this.");
                    jsc.append(name);
                    jsc.append(".equals(temp.");
                    jsc.append(name);
                    jsc.append(")");
                }
                jsc.append(")) ");
                jsc.indent();
                jsc.add("return false;");
                jsc.unindent();
                jsc.unindent();
                jsc.add("}");
                jsc.add("else if (temp.");
                jsc.append(name);
                jsc.append(" != null)");
            }
            jsc.indent();
            jsc.add("return false;");
            jsc.unindent();
        }
        jsc.add("return true;");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return false;");
    }

    public void createTestableMethods(JClass jclass, FactoryState state) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        jclass.addInterface("org.castor.xmlctf.CastorTestable");
        jclass.addImport("org.castor.xmlctf.CastorTestable");
        jclass.addImport("org.castor.xmlctf.RandomHelper");
        this.createRandomizeFields(jclass, state);
        this.createDumpFields(jclass);
    }

    private void createRandomizeFields(JClass jclass, FactoryState state) {
        JMethod jMethod = new JMethod("randomizeFields");
        jMethod.addException(new JClass("InstantiationException"), "if we try to instantiate an abstract class or interface");
        jMethod.addException(new JClass("IllegalAccessException"), "if we do not have access to the field, for example if it is private");
        jMethod.setComment("implementation of org.castor.xmlctf.CastorTestable");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        JField[] fields = jclass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            JField temp = fields[i];
            JType type = temp.getType();
            String name = temp.getName();
            if (state.getFieldInfoForChoice() != null && name.equals(state.getFieldInfoForChoice().getName())) continue;
            name = name.startsWith("_") ? JavaNaming.toJavaClassName((String)name.substring(1)) : JavaNaming.toJavaClassName((String)name);
            String setName = "set" + name;
            if (name.indexOf("Has") != -1) continue;
            if (type instanceof JCollectionType) {
                int listLocat = name.lastIndexOf("List");
                String tempName = name;
                if (listLocat != -1) {
                    tempName = tempName.substring(0, listLocat);
                }
                String methodName = JavaNaming.toJavaClassName((String)tempName);
                methodName = "get" + methodName;
                JMethod method = jclass.getMethod(methodName, 0);
                if (method == null) continue;
                String componentName = method.getReturnType().getName();
                jsc.add(temp.getName());
                jsc.append(" = RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append(", ");
                jsc.append(componentName);
                jsc.append(".class);");
            } else if (type.isPrimitive()) {
                jsc.add(setName);
                jsc.append("(RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append("));");
            } else if (type.isArray()) {
                jsc.add(setName);
                jsc.append("((");
                jsc.append(type.toString());
                jsc.append(")RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append(", java.lang.reflect.Array.class));");
            } else {
                jsc.add(setName);
                jsc.append("((");
                jsc.append(type.getName());
                jsc.append(")RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append(", ");
                jsc.append(type.getName());
                jsc.append(".class));");
            }
            jsc.add("");
        }
    }

    private void createDumpFields(JClass jclass) {
        JMethod jMethod = new JMethod("dumpFields", SGTypes.STRING, "a String representation of all of the fields for " + jclass.getName());
        jMethod.setComment("implementation of org.castor.xmlctf.CastorTestable");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("StringBuffer result = new StringBuffer(\"DumpFields() for element: ");
        jsc.append(jclass.getName());
        jsc.append("\\n\");");
        JField[] fields = jclass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            JField temp = fields[i];
            String name = temp.getName();
            if (temp.getType().isPrimitive() || temp.getType().getName().startsWith("java.lang.")) {
                jsc.add("result.append(\"Field ");
                jsc.append(name);
                jsc.append(":\" +");
                jsc.append(name);
                jsc.append("+\"\\n\");");
            } else if (temp.getType().isArray()) {
                jsc.add("if (");
                jsc.append(name);
                jsc.append(" != null) {");
                jsc.indent();
                jsc.add("result.append(\"[\");");
                jsc.add("for (int i = 0; i < ");
                jsc.append(name);
                jsc.append(".length; i++) {");
                jsc.indent();
                jsc.add("result.append(");
                jsc.append(name);
                jsc.append("[i] + \" \");");
                jsc.unindent();
                jsc.add("}");
                jsc.add("result.append(\"]\");");
                jsc.unindent();
                jsc.add("}");
            } else {
                jsc.add("if ( (");
                jsc.append(name);
                jsc.append(" != null) && (");
                jsc.append(name);
                jsc.append(".getClass().isAssignableFrom(CastorTestable.class)))");
                jsc.indent();
                jsc.add("result.append(((CastorTestable)");
                jsc.append(name);
                jsc.append(").dumpFields());");
                jsc.unindent();
                jsc.add("else result.append(\"Field ");
                jsc.append(name);
                jsc.append(":\" +");
                jsc.append(name);
                jsc.append("+\"\\n\");");
            }
            jsc.add("");
        }
        jsc.add("");
        jsc.add("return result.toString();");
    }

    private void createValidateMethods(JClass jClass) {
        JMethod jMethod = null;
        JSourceCode jsc = null;
        jMethod = new JMethod("validate");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jClass.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("org.exolab.castor.xml.Validator validator = new ");
        jsc.append("org.exolab.castor.xml.Validator();");
        jsc.add("validator.validate(this);");
        jMethod = new JMethod("isValid", JType.BOOLEAN, "true if this object is valid according to the schema");
        jsc = jMethod.getSourceCode();
        jsc.add("try {");
        jsc.indent();
        jsc.add("validate();");
        jsc.unindent();
        jsc.add("} catch (org.exolab.castor.xml.ValidationException vex) {");
        jsc.indent();
        jsc.add("return false;");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return true;");
        jClass.addMethod(jMethod);
    }

    private String resolveClassName(String name, String packageName) {
        if (packageName != null && packageName.length() > 0) {
            return packageName + "." + name;
        }
        return name;
    }

    private String processAnnotations(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            StringBuffer comment = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Annotation ann = (Annotation)enumeration.nextElement();
                Enumeration documentations = ann.getDocumentation();
                while (documentations.hasMoreElements()) {
                    Documentation documentation = (Documentation)documentations.nextElement();
                    String content = documentation.getContent();
                    if (content == null) continue;
                    comment.append(content);
                }
            }
            return this.normalize(comment.toString());
        }
        return null;
    }

    private void processAttributes(ExtendedBinding binding, ComplexType complexType, FactoryState state) {
        if (complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        while (enumeration.hasMoreElements()) {
            AttributeDecl attr = (AttributeDecl)enumeration.nextElement();
            component.setView((Annotated)attr);
            SimpleType sType = attr.getSimpleType();
            for (XMLType baseXMLType = complexType.getBaseType(); sType == null && baseXMLType != null && baseXMLType instanceof ComplexType; baseXMLType = baseXMLType.getBaseType()) {
                ComplexType baseComplexType = (ComplexType)baseXMLType;
                AttributeDecl baseAttribute = baseComplexType.getAttributeDecl(attr.getName());
                if (baseAttribute == null || (sType = baseAttribute.getSimpleType()) == null) continue;
                attr.setSimpleType(sType);
                break;
            }
            if (sType == null && attr.getReference() != null) {
                attr.setSimpleType(attr.getReference().getSimpleType());
            }
            if (sType != null && !SimpleTypesFactory.isBuiltInType((int)sType.getTypeCode()) && sType.getSchema() == component.getSchema() && state.resolve(sType) == null && sType.hasFacet("enumeration")) {
                this.createSourceCode(component.getBinding(), sType, state.getSGStateInfo());
            }
            FieldInfo fieldInfo = this._memberFactory.createFieldInfo(component, state, this.getConfig().useJava50());
            this.handleField(fieldInfo, state);
        }
    }

    private void processComplexType(ComplexType complexType, FactoryState state) {
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        component.setView((Annotated)complexType);
        String typeName = component.getXMLName();
        ClassInfo classInfo = state.getClassInfo();
        classInfo.setSchemaType(new XSClass(state.getJClass(), typeName));
        XMLType base = complexType.getBaseType();
        if (base != null) {
            if (base.isComplexType()) {
                String baseClassName = null;
                component.setView((Annotated)base);
                if (base.getSchema() == complexType.getSchema()) {
                    ClassInfo cInfo = state.resolve(base);
                    if (cInfo == null) {
                        JClass[] classes = this.createSourceCode(component, state.getSGStateInfo());
                        cInfo = state.resolve(base);
                        baseClassName = classes[0].getName();
                    } else {
                        baseClassName = cInfo.getJClass().getName();
                    }
                    classInfo.setBaseClass(cInfo);
                } else {
                    baseClassName = component.getQualifiedName();
                }
                component.setView((Annotated)complexType);
                state.getJClass().setSuperClass(baseClassName);
            }
            if (complexType.getContentType().getType() == 4) {
                SimpleContent simpleContent = (SimpleContent)complexType.getContentType();
                SimpleType temp = simpleContent.getSimpleType();
                SimpleType baseType = (SimpleType)temp.getBaseType();
                XSType xsType = this._typeConversion.convertType(temp, state.getPackageName(), this.getConfig().useJava50());
                FieldInfo fieldInfo = null;
                if (baseType != null && this.extendsSimpleType(state.getJClass(), baseType, state)) {
                    if (xsType.isEnumerated()) {
                        fieldInfo = this._memberFactory.createFieldInfoForContent(xsType, this.getConfig().useJava50());
                        fieldInfo.setBound(false);
                        this.handleField(fieldInfo, state);
                        String mname = fieldInfo.getReadMethodName();
                        JClass jClass = state.getJClass();
                        JMethod method = jClass.getMethod(mname, 0);
                        jClass.removeMethod(method);
                        mname = fieldInfo.getWriteMethodName();
                        method = jClass.getMethod(mname, 0);
                        JSourceCode jsc = method.getSourceCode();
                        jsc.add("super.");
                        jsc.append(mname);
                        jsc.append("(this.");
                        jsc.append(fieldInfo.getName());
                        jsc.append(".toString());");
                    }
                } else {
                    while (temp.getBaseType() != null) {
                        temp = (SimpleType)temp.getBaseType();
                    }
                    xsType = this._typeConversion.convertType(temp, state.getPackageName(), this.getConfig().useJava50());
                    fieldInfo = this._memberFactory.createFieldInfoForContent(xsType, this.getConfig().useJava50());
                    this.handleField(fieldInfo, state);
                }
            }
        }
        if (!state.isCreateGroupItem()) {
            this.processAttributes(component.getBinding(), complexType, state);
            component.setView((Annotated)complexType);
            if (complexType.getContentType() == ContentType.mixed) {
                FieldInfo fieldInfo = this._memberFactory.createFieldInfoForContent(new XSString(), this.getConfig().useJava50());
                this.handleField(fieldInfo, state);
            }
        }
        this.processContentModel((ContentModelGroup)complexType, state);
    }

    private void processContentModel(ContentModelGroup model, FactoryState state) {
        ContentModelGroup contentModel = model;
        Enumeration enumeration = contentModel.enumerate();
        if (state.getClassInfo().isChoice() && state.getFieldInfoForChoice() == null) {
            state.setFieldInfoForChoice(this._memberFactory.createFieldInfoForChoiceValue());
            state.getFieldInfoForChoice().createJavaField(state.getJClass());
            state.getFieldInfoForChoice().createAccessMethods(state.getJClass(), this.getConfig().useJava50());
        }
        FieldInfo fieldInfo = null;
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        while (enumeration.hasMoreElements()) {
            Annotated annotated = (Annotated)enumeration.nextElement();
            component.setView(annotated);
            switch (annotated.getStructureType()) {
                case 8: {
                    fieldInfo = this._memberFactory.createFieldInfo(component, state, this.getConfig().useJava50());
                    if (contentModel.getMinOccurs() == 0) {
                        fieldInfo.setRequired(false);
                    }
                    this.handleField(fieldInfo, state);
                    break;
                }
                case 10: {
                    Group group = (Group)annotated;
                    if (contentModel instanceof ComplexType || contentModel instanceof ModelGroup) {
                        if (group.getOrder() == Order.choice) {
                            state.getClassInfo().getGroupInfo().setAsChoice();
                        } else if (group.getOrder() == Order.all) {
                            state.getClassInfo().getGroupInfo().setAsAll();
                        } else if (group.getOrder() == Order.seq) {
                            state.getClassInfo().getGroupInfo().setAsSequence();
                        }
                    }
                    if (!(contentModel instanceof ComplexType) && !(contentModel instanceof ModelGroup)) {
                        ModelGroup mg;
                        if (contentModel instanceof ModelGroup && (mg = (ModelGroup)contentModel).isReference()) {
                            contentModel = mg.getReference();
                        }
                        if (contentModel.getParticleCount() <= 0) break;
                        fieldInfo = this._memberFactory.createFieldInfo(component, state.getSGStateInfo(), this.getConfig().useJava50());
                        this.handleField(fieldInfo, state);
                        break;
                    }
                    this.processContentModel((ContentModelGroup)group, state);
                    break;
                }
                case 16: {
                    ModelGroup modelgroup = (ModelGroup)annotated;
                    if (modelgroup.getName() != null) {
                        if (modelgroup.isReference()) {
                            modelgroup = modelgroup.getReference();
                        }
                        if (modelgroup.getParticleCount() <= 0) break;
                        fieldInfo = this._memberFactory.createFieldInfo(component, state.getSGStateInfo(), this.getConfig().useJava50());
                        this.handleField(fieldInfo, state);
                        break;
                    }
                    this.processContentModel(modelgroup.getContentModelGroup(), state);
                    break;
                }
                case 24: {
                    Wildcard wildcard = (Wildcard)annotated;
                    FieldInfo fieldForAny = this._memberFactory.createFieldInfoForAny(wildcard, this.getConfig().useJava50());
                    this.handleField(fieldForAny, state);
                    break;
                }
            }
        }
    }

    private void processEnumeration(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        if (this.getConfig().useEnumeratedTypeInterface()) {
            state.getJClass().addImport(ENUM_ACCESS_INTERFACE);
            state.getJClass().addInterface(ENUM_ACCESS_INTERFACE);
        }
        switch (this._enumerationType) {
            case 0: {
                this.processEnumerationAsBaseType(binding, simpleType, state);
                break;
            }
            default: {
                this.processEnumerationAsNewObject(binding, simpleType, state);
            }
        }
    }

    private void processEnumerationAsNewObject(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        this._enumerationFactory.processEnumerationAsNewObject(binding, simpleType, state);
    }

    private void processEnumerationAsBaseType(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        this._enumerationFactory.processEnumerationAsBaseType(binding, simpleType, state);
    }

    private void handleField(FieldInfo fieldInfo, FactoryState state) {
        String warn;
        SGStateInfo sInfo;
        if (fieldInfo == null) {
            return;
        }
        if (CLASS_METHOD_SUFFIX.equals(fieldInfo.getMethodSuffix())) {
            sInfo = state.getSGStateInfo();
            if (!sInfo.getSuppressNonFatalWarnings()) {
                warn = "warning a field name conflicts with \"class\", please use a binding file to specify a different name for the " + fieldInfo.getNodeTypeName() + " '" + fieldInfo.getNodeName() + "'.";
                sInfo.getDialog().notify(warn);
            }
        } else if (CLASS_KEYWORD.equals(fieldInfo.getNodeName()) && !(sInfo = state.getSGStateInfo()).getSuppressNonFatalWarnings()) {
            warn = "warning a field name conflicts with \"class\" and is being replaced by \"clazz\". You may use a binding file to specify a different name for the " + fieldInfo.getNodeTypeName() + " '" + fieldInfo.getNodeName() + "'.";
            sInfo.getDialog().notify(warn);
        }
        JSourceCode scInitializer = state.getJClass().getConstructor(0).getSourceCode();
        ClassInfo base = state.getClassInfo().getBaseClass();
        boolean present = false;
        if (base != null) {
            switch (fieldInfo.getNodeType()) {
                case 0: {
                    present = base.getAttributeField(fieldInfo.getNodeName()) != null;
                    break;
                }
                case 1: {
                    String baseNodeName = fieldInfo.getNodeName();
                    if (baseNodeName.equals("-error-if-this-is-used-")) break;
                    present = base.getElementField(baseNodeName) != null;
                    break;
                }
            }
        }
        state.getClassInfo().addFieldInfo(fieldInfo);
        boolean bl = present = present && !fieldInfo.isMultivalued();
        if (!present) {
            if (state.getFieldInfoForChoice() != null && fieldInfo != state.getFieldInfoForChoice()) {
                fieldInfo.setFieldInfoReference(state.getFieldInfoForChoice());
            }
            fieldInfo.createJavaField(state.getJClass());
            if (!fieldInfo.isTransient()) {
                fieldInfo.createAccessMethods(state.getJClass(), this.getConfig().useJava50());
                if (fieldInfo.isBound()) {
                    state.setBoundProperties(true);
                }
            }
        }
        fieldInfo.generateInitializerCode(scInitializer);
    }

    private boolean extendsSimpleType(JClass jClass, SimpleType type, FactoryState state) {
        ClassInfo cInfo;
        String superClassName = jClass.getSuperClassQualifiedName();
        if (superClassName != null && (cInfo = state.resolve(type)) != null) {
            return superClassName.equals(cInfo.getJClass().getName());
        }
        return false;
    }
}

